/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerConfiguration;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-secrets-manager")
public class SecretsManagerComponent
extends DefaultComponent {
    @Metadata
    private SecretsManagerConfiguration configuration = new SecretsManagerConfiguration();

    public SecretsManagerComponent() {
        this(null);
    }

    public SecretsManagerComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SecretsManagerConfiguration configuration = this.configuration != null ? this.configuration.copy() : new SecretsManagerConfiguration();
        SecretsManagerEndpoint endpoint = new SecretsManagerEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && configuration.getSecretsManagerClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, Amazon Secrets Manager client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public SecretsManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SecretsManagerConfiguration configuration) {
        this.configuration = configuration;
    }
}

