/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager;

import java.util.Map;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerConfiguration;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerEndpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;

public class SecretsManagerProducerHealthCheck
extends AbstractHealthCheck {
    private final SecretsManagerEndpoint secretsManagerEndpoint;

    public SecretsManagerProducerHealthCheck(SecretsManagerEndpoint secretsManagerEndpoint, String clientId) {
        super("camel", "producer:aws-secrets-manager-" + clientId);
        this.secretsManagerEndpoint = secretsManagerEndpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        SecretsManagerConfiguration configuration = this.secretsManagerEndpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !SecretsManagerClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            SecretsManagerClient secretsManagerClient = this.secretsManagerEndpoint.getSecretsManagerClient();
            secretsManagerClient.listSecrets((ListSecretsRequest)ListSecretsRequest.builder().maxResults(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

