/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ses;

import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ses.SesComponentVerifierExtension;
import org.apache.camel.component.aws.ses.SesConfiguration;
import org.apache.camel.component.aws.ses.SesEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-ses")
public class SesComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private SesConfiguration configuration;

    public SesComponent() {
        this(null);
    }

    public SesComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new SesComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("From must be specified.");
        }
        SesConfiguration configuration = this.configuration != null ? this.configuration.copy() : new SesConfiguration();
        configuration.setFrom(remaining);
        SesEndpoint endpoint = new SesEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonSESClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSESClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public SesConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SesConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(SesConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonSimpleEmailService.class);
        if (clients.size() == 1) {
            configuration.setAmazonSESClient((AmazonSimpleEmailService)clients.stream().findFirst().get());
        }
    }
}

