/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.Protocol;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sqs.AmazonSQS;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.aws.sns.SnsEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SnsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return SnsEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return SnsEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "amazonSNSClient": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAmazonSNSClient((AmazonSNS)SnsEndpointConfigurer.property((CamelContext)camelContext, AmazonSNS.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyProtocol": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)SnsEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)SnsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "amazonSQSClient": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAmazonSQSClient((AmazonSQS)SnsEndpointConfigurer.property((CamelContext)camelContext, AmazonSQS.class, (Object)value));
                return true;
            }
            case "queueUrl": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setQueueUrl((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscribeSNStoSQS": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setSubscribeSNStoSQS((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "kmsMasterKeyId": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setKmsMasterKeyId((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverSideEncryptionEnabled": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setServerSideEncryptionEnabled((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoCreateTopic": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAutoCreateTopic((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subject": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setSubject((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "policy": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setPolicy((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "messageStructure": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setMessageStructure((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "headerFilterStrategy": {
                ((SnsEndpoint)((Object)endpoint)).setHeaderFilterStrategy((HeaderFilterStrategy)SnsEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((SnsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((SnsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((SnsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SnsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((SnsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SnsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SnsEndpoint)((Object)endpoint)).setSynchronous((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((SnsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "amazonsnsclient": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAmazonSNSClient((AmazonSNS)SnsEndpointConfigurer.property((CamelContext)camelContext, AmazonSNS.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyprotocol": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)SnsEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)SnsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "amazonsqsclient": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAmazonSQSClient((AmazonSQS)SnsEndpointConfigurer.property((CamelContext)camelContext, AmazonSQS.class, (Object)value));
                return true;
            }
            case "queueurl": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setQueueUrl((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscribesnstosqs": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setSubscribeSNStoSQS((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "kmsmasterkeyid": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setKmsMasterKeyId((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serversideencryptionenabled": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setServerSideEncryptionEnabled((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autocreatetopic": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setAutoCreateTopic((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subject": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setSubject((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "policy": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setPolicy((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "messagestructure": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setMessageStructure((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((SnsEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)SnsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "headerfilterstrategy": {
                ((SnsEndpoint)((Object)endpoint)).setHeaderFilterStrategy((HeaderFilterStrategy)SnsEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((SnsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((SnsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((SnsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SnsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((SnsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SnsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SnsEndpoint)((Object)endpoint)).setSynchronous((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((SnsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SnsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

