/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.sqs.SqsComponentVerifierExtension;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="aws-sqs")
public class SqsComponent
extends DefaultComponent {
    @Metadata
    private SqsConfiguration configuration = new SqsConfiguration();

    public SqsComponent() {
        this(null);
    }

    public SqsComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new SqsComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SqsConfiguration configuration;
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Queue name must be specified.");
        }
        SqsConfiguration sqsConfiguration = configuration = this.configuration != null ? this.configuration.copy() : new SqsConfiguration();
        if (remaining.startsWith("arn:")) {
            String[] parts = remaining.split(":");
            if (parts.length != 6 || !parts[2].equals("sqs")) {
                throw new IllegalArgumentException("Queue arn must be in format arn:aws:sqs:region:account:name.");
            }
            configuration.setRegion(Regions.fromName((String)parts[3]).toString());
            configuration.setQueueOwnerAWSAccountId(parts[4]);
            configuration.setQueueName(parts[5]);
        } else {
            configuration.setQueueName(remaining);
        }
        SqsEndpoint sqsEndpoint = new SqsEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)sqsEndpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonSQSClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSQSClient or accessKey and secretKey must be specified.");
        }
        if (configuration.isExtendMessageVisibility() && configuration.getVisibilityTimeout() == null) {
            throw new IllegalArgumentException("Extending message visibility (extendMessageVisibility) requires visibilityTimeout to be set on the Endpoint.");
        }
        return sqsEndpoint;
    }

    public SqsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SqsConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(SqsConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonSQS.class);
        if (clients.size() == 1) {
            configuration.setAmazonSQSClient((AmazonSQS)clients.stream().findFirst().get());
        }
    }
}

