/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.cw.CwComponent;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@Conditional(value={Condition.class})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
public class CwComponentAutoConfiguration {
    @Lazy
    @Bean(name={"aws-cw-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={CwComponent.class})
    public CwComponent configureCwComponent(CamelContext camelContext) throws Exception {
        CwComponent component = new CwComponent();
        component.setCamelContext(camelContext);
        return component;
    }

    public static class Condition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            boolean groupEnabled = this.isEnabled(conditionContext, "camel.component.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.component.aws-cw", (Object[])new Object[0]);
            if (this.isEnabled(conditionContext, "camel.component.aws-cw.", groupEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

