/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks.springboot;

import com.amazonaws.services.eks.AmazonEKS;
import org.apache.camel.component.aws.eks.EKSConfiguration;
import org.apache.camel.component.aws.eks.EKSOperations;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.component.aws-eks")
public class EKSComponentConfiguration
extends ComponentConfigurationPropertiesCommon {
    private Boolean enabled;
    private EKSConfigurationNestedConfiguration configuration;
    private String accessKey;
    private String secretKey;
    private String region;
    private Boolean resolvePropertyPlaceholders = true;

    public EKSConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EKSConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return this.resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public static class EKSConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = EKSConfiguration.class;
        private AmazonEKS eksClient;
        private String accessKey;
        private String secretKey;
        private EKSOperations operation;
        private String proxyHost;
        private Integer proxyPort;
        private String region;

        public AmazonEKS getEksClient() {
            return this.eksClient;
        }

        public void setEksClient(AmazonEKS eksClient) {
            this.eksClient = eksClient;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public EKSOperations getOperation() {
            return this.operation;
        }

        public void setOperation(EKSOperations operation) {
            this.operation = operation;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }
    }
}

