/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.swf.CamelSWFActivityClient;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWFActivityProducer
extends DefaultProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SWFActivityProducer.class);
    private final CamelSWFActivityClient camelSWFClient;
    private SWFEndpoint endpoint;
    private SWFConfiguration configuration;
    private transient String swfActivityProducerToString;

    public SWFActivityProducer(SWFEndpoint endpoint, CamelSWFActivityClient camelSWFActivityClient) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        this.camelSWFClient = camelSWFActivityClient;
    }

    public void process(Exchange exchange) throws Exception {
        String eventName = this.getEventName(exchange);
        String version = this.getVersion(exchange);
        LOGGER.debug("scheduleActivity : " + eventName + " : " + version);
        Object result = this.camelSWFClient.scheduleActivity(eventName, version, exchange.getIn().getBody());
        this.endpoint.setResult(exchange, result);
    }

    private String getEventName(Exchange exchange) {
        String eventName = (String)exchange.getIn().getHeader("CamelSWFEventName", String.class);
        return eventName != null ? eventName : this.configuration.getEventName();
    }

    private String getVersion(Exchange exchange) {
        String version = (String)exchange.getIn().getHeader("CamelSWFVersion", String.class);
        return version != null ? version : this.configuration.getVersion();
    }

    public String toString() {
        if (this.swfActivityProducerToString == null) {
            this.swfActivityProducerToString = "SWFActivityProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.swfActivityProducerToString;
    }
}

