/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.ArrayList;
import org.apache.camel.component.aws.swf.CamelWorkflowDefinitionFactory;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFWorkflowConsumer;

public class CamelWorkflowDefinitionFactoryFactory
extends WorkflowDefinitionFactoryFactory {
    private final SWFWorkflowConsumer swfWorkflowConsumer;
    private final SWFConfiguration configuration;

    public CamelWorkflowDefinitionFactoryFactory(SWFWorkflowConsumer swfWorkflowConsumer, SWFConfiguration configuration) {
        this.swfWorkflowConsumer = swfWorkflowConsumer;
        this.configuration = configuration;
    }

    public WorkflowDefinitionFactory getWorkflowDefinitionFactory(WorkflowType workflowType) {
        WorkflowTypeRegistrationOptions registrationOptions = this.configuration.getWorkflowTypeRegistrationOptions() != null ? this.configuration.getWorkflowTypeRegistrationOptions() : new WorkflowTypeRegistrationOptions();
        JsonDataConverter dataConverter = this.configuration.getDataConverter() != null ? this.configuration.getDataConverter() : new JsonDataConverter();
        return new CamelWorkflowDefinitionFactory(this.swfWorkflowConsumer, workflowType, registrationOptions, (DataConverter)dataConverter);
    }

    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        ArrayList<WorkflowType> workflowTypes = new ArrayList<WorkflowType>(1);
        WorkflowType workflowType = new WorkflowType();
        workflowType.setName(this.configuration.getEventName());
        workflowType.setVersion(this.configuration.getVersion());
        workflowTypes.add(workflowType);
        return workflowTypes;
    }
}

