/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.component.aws.swf.SWFWorkflowConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelWorkflowDefinition
extends WorkflowDefinition {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(CamelWorkflowDefinition.class);
    private SWFWorkflowConsumer swfWorkflowConsumer;
    private DecisionContext decisionContext;
    private DataConverter dataConverter;
    private final DecisionContextProvider contextProvider = new DecisionContextProviderImpl();
    private final WorkflowClock workflowClock = this.contextProvider.getDecisionContext().getWorkflowClock();

    public CamelWorkflowDefinition(SWFWorkflowConsumer swfWorkflowConsumer, DecisionContext decisionContext, DataConverter dataConverter) {
        this.swfWorkflowConsumer = swfWorkflowConsumer;
        this.decisionContext = decisionContext;
        this.dataConverter = dataConverter;
    }

    public Promise<String> execute(final String input) throws WorkflowException {
        final Settable result = new Settable();
        final AtomicReference methodResult = new AtomicReference();
        new TryCatchFinally(){

            protected void doTry() throws Throwable {
                Object[] parameters = (Object[])CamelWorkflowDefinition.this.dataConverter.fromData(input, Object[].class);
                long startTime = CamelWorkflowDefinition.this.workflowClock.currentTimeMillis();
                boolean replaying = CamelWorkflowDefinition.this.contextProvider.getDecisionContext().getWorkflowClock().isReplaying();
                LOGGER.debug("Processing workflow execute");
                Object r = CamelWorkflowDefinition.this.swfWorkflowConsumer.processWorkflow(parameters, startTime, replaying);
                if (r instanceof Promise) {
                    methodResult.set((Promise)r);
                } else if (r != null) {
                    methodResult.set(new Settable(r));
                }
            }

            protected void doCatch(Throwable e) throws Throwable {
                if (!(e instanceof CancellationException) || !CamelWorkflowDefinition.this.decisionContext.getWorkflowContext().isCancelRequested()) {
                    CamelWorkflowDefinition.this.throwWorkflowException(CamelWorkflowDefinition.this.dataConverter, e);
                }
            }

            protected void doFinally() throws Throwable {
                Promise r = (Promise)methodResult.get();
                if (r == null || r.isReady()) {
                    Object workflowResult = r == null ? null : r.get();
                    String convertedResult = CamelWorkflowDefinition.this.dataConverter.toData(workflowResult);
                    result.set((Object)convertedResult);
                }
            }
        };
        return result;
    }

    public void signalRecieved(String signalName, String input) throws WorkflowException {
        Object[] parameters = (Object[])this.dataConverter.fromData(input, Object[].class);
        try {
            LOGGER.debug("Processing workflow signalReceived");
            this.swfWorkflowConsumer.signalReceived(parameters);
        }
        catch (Exception e) {
            this.throwWorkflowException(this.dataConverter, e);
            throw new IllegalStateException("Unreacheable");
        }
    }

    public String getWorkflowState() throws WorkflowException {
        try {
            LOGGER.debug("Processing workflow getWorkflowState");
            Object result = this.swfWorkflowConsumer.getWorkflowState(null);
            return this.dataConverter.toData(result);
        }
        catch (Exception e) {
            this.throwWorkflowException(this.dataConverter, e);
            throw new IllegalStateException("Unreachable");
        }
    }

    private void throwWorkflowException(DataConverter c, Throwable exception) throws WorkflowException {
        if (exception instanceof WorkflowException) {
            throw (WorkflowException)exception;
        }
        String reason = WorkflowExecutionUtils.truncateReason((String)exception.getMessage());
        String details = null;
        try {
            details = c.toData((Object)exception);
        }
        catch (DataConverterException dataConverterException) {
            if (dataConverterException.getCause() == null) {
                dataConverterException.initCause(exception);
            }
            throw dataConverterException;
        }
        throw new WorkflowException(reason, details);
    }
}

