/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SWFEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":type";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "aws-swf".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "type", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(31);
        props.add("activityTypeRegistrationOptions");
        props.add("clientConfigurationParameters");
        props.add("stateResultType");
        props.add("amazonSWClient");
        props.add("activitySchedulingOptions");
        props.add("activityThreadPoolSize");
        props.add("type");
        props.add("terminationDetails");
        props.add("bridgeErrorHandler");
        props.add("workflowTypeRegistrationOptions");
        props.add("activityTypeExecutionOptions");
        props.add("startWorkflowOptionsParameters");
        props.add("eventName");
        props.add("dataConverter");
        props.add("taskStartToCloseTimeout");
        props.add("activityList");
        props.add("terminationReason");
        props.add("signalName");
        props.add("secretKey");
        props.add("exchangePattern");
        props.add("version");
        props.add("executionStartToCloseTimeout");
        props.add("sWClientParameters");
        props.add("lazyStartProducer");
        props.add("accessKey");
        props.add("domainName");
        props.add("childPolicy");
        props.add("region");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("workflowList");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("secretKey");
        secretProps.add("accessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

