/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.translate;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.translate.AmazonTranslate;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.translate.TranslateConfiguration;
import org.apache.camel.component.aws.translate.TranslateEndpoint;
import org.apache.camel.component.aws.translate.TranslateOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class TranslateProducer
extends DefaultProducer {
    private transient String translateProducerToString;

    public TranslateProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case translateText: {
                this.translateText(this.getEndpoint().getTranslateClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private TranslateOperations determineOperation(Exchange exchange) {
        TranslateOperations operation = (TranslateOperations)((Object)exchange.getIn().getHeader("CamelAwsTranslateOperation", TranslateOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected TranslateConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.translateProducerToString == null) {
            this.translateProducerToString = "TranslateProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.translateProducerToString;
    }

    public TranslateEndpoint getEndpoint() {
        return (TranslateEndpoint)super.getEndpoint();
    }

    private void translateText(AmazonTranslate translateClient, Exchange exchange) {
        TranslateTextResult result;
        String target;
        String source;
        TranslateTextRequest request = new TranslateTextRequest();
        if (!this.getConfiguration().isAutodetectSourceLanguage()) {
            source = (String)exchange.getIn().getHeader("CamelAwsTranslateSourceLanguage", String.class);
            target = (String)exchange.getIn().getHeader("CamelAwsTranslateTargetLanguage", String.class);
            if (ObjectHelper.isEmpty((Object)source) || ObjectHelper.isEmpty((Object)target)) {
                throw new IllegalArgumentException("Source and target language must be specified");
            }
            request.setSourceLanguageCode(source);
            request.setTargetLanguageCode(target);
        } else {
            source = "auto";
            target = (String)exchange.getIn().getHeader("CamelAwsTranslateTargetLanguage", String.class);
            if (ObjectHelper.isEmpty((Object)source) || ObjectHelper.isEmpty((Object)target)) {
                throw new IllegalArgumentException("Target language must be specified when autodetection of source language is enabled");
            }
            request.setSourceLanguageCode(source);
            request.setTargetLanguageCode(target);
        }
        request.setText((String)exchange.getMessage().getBody(String.class));
        try {
            result = translateClient.translateText(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Translate Text command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = TranslateProducer.getMessageForResponse(exchange);
        message.setBody((Object)result.getTranslatedText());
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

