/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.translate;

import com.amazonaws.services.translate.AmazonTranslate;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.translate.TranslateComponentVerifierExtension;
import org.apache.camel.component.aws.translate.TranslateConfiguration;
import org.apache.camel.component.aws.translate.TranslateEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-translate")
public class TranslateComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private TranslateConfiguration configuration;

    public TranslateComponent() {
        this(null);
    }

    public TranslateComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new TranslateComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TranslateConfiguration configuration = this.configuration != null ? this.configuration.copy() : new TranslateConfiguration();
        TranslateEndpoint endpoint = new TranslateEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getTranslateClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon translate client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public TranslateConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TranslateConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(TranslateConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonTranslate.class);
        if (clients.size() == 1) {
            configuration.setTranslateClient((AmazonTranslate)clients.stream().findFirst().get());
        }
    }
}

