/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Subsegment;
import java.lang.invoke.MethodHandles;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.xray.XRayTrace;
import org.apache.camel.component.aws.xray.XRayTracer;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.DelegateSyncProcessor;
import org.apache.camel.spi.InterceptStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceAnnotatedTracingStrategy
implements InterceptStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Processor wrapProcessorInInterceptors(CamelContext camelContext, ProcessorDefinition<?> processorDefinition, Processor target, Processor nextTarget) throws Exception {
        XRayTrace annotation;
        DelegateSyncProcessor syncProcessor;
        Class<?> processorClass = processorDefinition.getClass();
        String shortName = processorDefinition.getShortName();
        if (processorDefinition instanceof BeanDefinition) {
            BeanProcessor beanProcessor = (BeanProcessor)nextTarget;
            if (null != beanProcessor && null != beanProcessor.getBean()) {
                processorClass = beanProcessor.getBean().getClass();
            }
        } else if (processorDefinition instanceof ProcessDefinition && null != (syncProcessor = (DelegateSyncProcessor)nextTarget) && null != syncProcessor.getProcessor()) {
            processorClass = syncProcessor.getProcessor().getClass();
        }
        if (processorClass == null) {
            LOG.trace("Could not identify processor class on target processor {}", (Object)target);
            return new DelegateAsyncProcessor(target);
        }
        if (!processorClass.isAnnotationPresent(XRayTrace.class)) {
            LOG.trace("{} does not contain an @XRayTrace annotation. Skipping interception", (Object)processorClass.getSimpleName());
            return new DelegateAsyncProcessor(target);
        }
        LOG.trace("Wrapping process definition {} of target {} in order for recording its trace", processorDefinition, processorClass);
        XRayTrace trace = annotation = processorClass.getAnnotation(XRayTrace.class);
        String metricName = trace.metricName();
        if ("".equals(metricName)) {
            metricName = processorClass.getSimpleName();
        }
        Class<?> type = processorClass;
        String name = shortName + ":" + metricName;
        return new DelegateAsyncProcessor(exchange -> {
            LOG.trace("Creating new subsegment for {} of type {} - EIP {}", new Object[]{name, type, target});
            Subsegment subsegment = AWSXRay.beginSubsegment((String)XRayTracer.sanitizeName(name));
            try {
                LOG.trace("Processing EIP {}", (Object)target);
                target.process(exchange);
            }
            catch (Exception ex) {
                LOG.trace("Handling exception thrown by invoked EIP {}", (Object)target);
                subsegment.addException((Throwable)ex);
                throw ex;
            }
            finally {
                LOG.trace("Closing down subsegment for {}", (Object)name);
                subsegment.close();
            }
        });
    }
}

