/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators.messaging;

import com.amazonaws.xray.entities.Entity;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.messaging.AbstractMessagingSegmentDecorator;

public class KafkaSegmentDecorator
extends AbstractMessagingSegmentDecorator {
    public static final String KAFKA_PARTITION_TAG = "kafka.partition";
    public static final String KAFKA_PARTITION_KEY_TAG = "kafka.partition.key";
    public static final String KAFKA_KEY_TAG = "kafka.key";
    public static final String KAFKA_OFFSET_TAG = "kafka.offset";
    protected static final String PARTITION_KEY = "kafka.PARTITION_KEY";
    protected static final String PARTITION = "kafka.PARTITION";
    protected static final String KEY = "kafka.KEY";
    protected static final String TOPIC = "kafka.TOPIC";
    protected static final String OFFSET = "kafka.OFFSET";

    @Override
    public String getComponent() {
        return "kafka";
    }

    @Override
    public String getDestination(Exchange exchange, Endpoint endpoint) {
        String topic = (String)exchange.getIn().getHeader(TOPIC);
        if (topic == null) {
            Map<String, String> queryParameters = KafkaSegmentDecorator.toQueryParameters(endpoint.getEndpointUri());
            topic = queryParameters.get("topic");
        }
        return topic != null ? topic : super.getDestination(exchange, endpoint);
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        String offset;
        String key;
        String partitionKey;
        super.pre(segment, exchange, endpoint);
        String partition = (String)exchange.getIn().getHeader(PARTITION);
        if (partition != null) {
            segment.putMetadata(KAFKA_PARTITION_TAG, (Object)partition);
        }
        if ((partitionKey = (String)exchange.getIn().getHeader(PARTITION_KEY)) != null) {
            segment.putMetadata(KAFKA_PARTITION_KEY_TAG, (Object)partitionKey);
        }
        if ((key = (String)exchange.getIn().getHeader(KEY)) != null) {
            segment.putMetadata(KAFKA_KEY_TAG, (Object)key);
        }
        if ((offset = (String)exchange.getIn().getHeader(OFFSET)) != null) {
            segment.putMetadata(KAFKA_OFFSET_TAG, (Object)offset);
        }
    }
}

