/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators;

import com.amazonaws.xray.entities.Entity;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.AbstractSegmentDecorator;

public class CqlSegmentDecorator
extends AbstractSegmentDecorator {
    public static final String CASSANDRA_DB_TYPE = "cassandra";
    protected static final String CAMEL_CQL_QUERY = "CamelCqlQuery";

    @Override
    public String getComponent() {
        return "cql";
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        Object cql;
        super.pre(segment, exchange, endpoint);
        segment.putMetadata("db.type", (Object)CASSANDRA_DB_TYPE);
        URI uri = URI.create(endpoint.getEndpointUri());
        if (uri.getPath() != null && uri.getPath().length() > 0) {
            segment.putMetadata("db.instance", (Object)uri.getPath().substring(1));
        }
        if ((cql = exchange.getIn().getHeader(CAMEL_CQL_QUERY)) != null) {
            segment.putSql("db.statement", cql);
        } else {
            Map<String, String> queryParameters = CqlSegmentDecorator.toQueryParameters(endpoint.getEndpointUri());
            if (queryParameters.containsKey("cql")) {
                segment.putSql("db.statement", (Object)queryParameters.get("cql"));
            }
        }
    }
}

