/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators.http;

import com.amazonaws.xray.entities.Entity;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.AbstractSegmentDecorator;

public abstract class AbstractHttpSegmentDecorator
extends AbstractSegmentDecorator {
    public static final String POST_METHOD = "POST";
    public static final String GET_METHOD = "GET";

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return this.getHttpMethod(exchange, endpoint);
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        super.pre(segment, exchange, endpoint);
        String httpUrl = this.getHttpUrl(exchange, endpoint);
        if (httpUrl != null) {
            segment.putMetadata("http.url", (Object)httpUrl);
        }
        segment.putMetadata("http.method", (Object)this.getHttpMethod(exchange, endpoint));
    }

    @Override
    public void post(Entity segment, Exchange exchange, Endpoint endpoint) {
        super.post(segment, exchange, endpoint);
        Object responseCode = exchange.getMessage().getHeader("CamelHttpResponseCode");
        if (responseCode instanceof Integer) {
            segment.putMetadata("htt.response.code", responseCode);
        }
    }

    protected String getHttpMethod(Exchange exchange, Endpoint endpoint) {
        Object method = exchange.getIn().getHeader("CamelHttpMethod");
        if (method instanceof String) {
            return (String)method;
        }
        if (exchange.getIn().getHeader("CamelHttpQuery") != null) {
            return GET_METHOD;
        }
        if (endpoint.getEndpointUri().indexOf(63) != -1) {
            return GET_METHOD;
        }
        if (exchange.getIn().getBody() != null) {
            return POST_METHOD;
        }
        return GET_METHOD;
    }

    protected String getHttpUrl(Exchange exchange, Endpoint endpoint) {
        Object url = exchange.getIn().getHeader("CamelHttpUrl");
        if (url instanceof String) {
            return (String)url;
        }
        Object uri = exchange.getIn().getHeader("CamelHttpUri");
        if (uri instanceof String) {
            return (String)uri;
        }
        int index = endpoint.getEndpointUri().lastIndexOf("http:");
        if (index != -1) {
            return endpoint.getEndpointUri().substring(index);
        }
        return null;
    }
}

