/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.cw.CwConfiguration;
import org.apache.camel.component.aws.cw.CwEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class CwComponent
extends UriEndpointComponent {
    public CwComponent() {
        super(CwEndpoint.class);
    }

    public CwComponent(CamelContext context) {
        super(context, CwEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CwConfiguration configuration = new CwConfiguration();
        this.setProperties(configuration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Metric namespace must be specified.");
        }
        configuration.setNamespace(remaining);
        if (configuration.getAmazonCwClient() == null) {
            throw new IllegalArgumentException("AmazonCwClient must be specified");
        }
        CwEndpoint endpoint = new CwEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }
}

