/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.services.kinesisfirehose.model.PutRecordRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordResult;
import com.amazonaws.services.kinesisfirehose.model.Record;
import java.nio.ByteBuffer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.common.AwsExchangeUtil;
import org.apache.camel.component.aws.firehose.KinesisFirehoseEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class KinesisFirehoseProducer
extends DefaultProducer {
    public KinesisFirehoseProducer(KinesisFirehoseEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KinesisFirehoseEndpoint getEndpoint() {
        return (KinesisFirehoseEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PutRecordRequest request = this.createRequest(exchange);
        this.log.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        PutRecordResult putRecordResult = this.getEndpoint().getClient().putRecord(request);
        this.log.trace("Received result [{}]", (Object)putRecordResult);
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setHeader("CamelAwsKinesisFirehoseRecordId", (Object)putRecordResult.getRecordId());
    }

    private PutRecordRequest createRequest(Exchange exchange) {
        ByteBuffer body = (ByteBuffer)exchange.getIn().getBody(ByteBuffer.class);
        Record record = new Record();
        record.setData(body);
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setDeliveryStreamName(this.getEndpoint().getStreamName());
        putRecordRequest.setRecord(record);
        return putRecordRequest;
    }
}

