/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3.client.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.client.S3Client;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ClientIAMOptimizedImpl
implements S3Client {
    private static final Logger LOG = LoggerFactory.getLogger(S3ClientIAMOptimizedImpl.class);
    private S3Configuration configuration;
    private int maxConnections;

    public S3ClientIAMOptimizedImpl(S3Configuration configuration, int maxConnections) {
        LOG.trace("Creating an AWS S3 client for an ec2 instance with IAM temporary credentials (normal for ec2s).");
        this.configuration = configuration;
        this.maxConnections = maxConnections;
    }

    @Override
    public AmazonS3 getS3Client() {
        AmazonS3 client = null;
        AmazonS3ClientBuilder clientBuilder = null;
        AmazonS3EncryptionClientBuilder encClientBuilder = null;
        ClientConfiguration clientConfiguration = null;
        if (this.configuration.hasProxyConfiguration()) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            clientConfiguration.setMaxConnections(this.maxConnections);
        } else {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setMaxConnections(this.maxConnections);
        }
        if (this.configuration.getAccessKey() != null || this.configuration.getSecretKey() != null) {
            LOG.trace("Do not pass in unnecessary static credentials when selecting the IAM credential option.");
        }
        if (!this.configuration.isUseEncryption()) {
            clientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false));
        } else if (this.configuration.isUseEncryption()) {
            StaticEncryptionMaterialsProvider encryptionMaterialsProvider = new StaticEncryptionMaterialsProvider(this.configuration.getEncryptionMaterials());
            encClientBuilder = (AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withClientConfiguration(clientConfiguration)).withEncryptionMaterials((EncryptionMaterialsProvider)encryptionMaterialsProvider).withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false));
        } else {
            clientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false));
        }
        if (!this.configuration.isUseEncryption()) {
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                clientBuilder = (AmazonS3ClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
            }
            clientBuilder = (AmazonS3ClientBuilder)clientBuilder.withPathStyleAccessEnabled(Boolean.valueOf(this.configuration.isPathStyleAccess()));
            client = (AmazonS3)clientBuilder.build();
        } else {
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                encClientBuilder = (AmazonS3EncryptionClientBuilder)encClientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
            }
            encClientBuilder = (AmazonS3EncryptionClientBuilder)encClientBuilder.withPathStyleAccessEnabled(Boolean.valueOf(this.configuration.isPathStyleAccess()));
            client = (AmazonS3)encClientBuilder.build();
        }
        return client;
    }
}

