/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.firehose.KinesisFirehoseComponentVerifierExtension;
import org.apache.camel.component.aws.firehose.KinesisFirehoseConfiguration;
import org.apache.camel.component.aws.firehose.KinesisFirehoseEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="aws-kinesis-firehose")
public class KinesisFirehoseComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private KinesisFirehoseConfiguration configuration = new KinesisFirehoseConfiguration();

    public KinesisFirehoseComponent() {
        this(null);
    }

    public KinesisFirehoseComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KinesisFirehoseComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KinesisFirehoseConfiguration configuration = this.configuration.copy();
        configuration.setStreamName(remaining);
        this.setProperties(configuration, parameters);
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        if (configuration.getAmazonKinesisFirehoseClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonKinesisFirehoseClient or accessKey and secretKey must be specified");
        }
        KinesisFirehoseEndpoint endpoint = new KinesisFirehoseEndpoint(uri, configuration, this);
        return endpoint;
    }

    public KinesisFirehoseConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KinesisFirehoseConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }
}

