/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.firehose.KinesisFirehoseComponent;
import org.apache.camel.component.aws.firehose.KinesisFirehoseConfiguration;
import org.apache.camel.component.aws.firehose.KinesisFirehoseProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.19.0", scheme="aws-kinesis-firehose", title="AWS Kinesis Firehose", syntax="aws-kinesis-firehose:streamName", producerOnly=true, label="cloud,messaging")
public class KinesisFirehoseEndpoint
extends DefaultEndpoint {
    @UriParam
    private KinesisFirehoseConfiguration configuration;
    private AmazonKinesisFirehose kinesisFirehoseClient;

    public KinesisFirehoseEndpoint(String uri, KinesisFirehoseConfiguration configuration, KinesisFirehoseComponent component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new KinesisFirehoseProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume messages from this endpoint");
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.kinesisFirehoseClient = this.configuration.getAmazonKinesisFirehoseClient() != null ? this.configuration.getAmazonKinesisFirehoseClient() : this.createKinesisFirehoseClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonKinesisFirehoseClient()) && this.kinesisFirehoseClient != null) {
            this.kinesisFirehoseClient.shutdown();
        }
        super.doStop();
    }

    public boolean isSingleton() {
        return true;
    }

    AmazonKinesisFirehose createKinesisFirehoseClient() {
        AmazonKinesisFirehose client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonKinesisFirehoseClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonKinesisFirehoseClientBuilder)((AmazonKinesisFirehoseClientBuilder)AmazonKinesisFirehoseClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonKinesisFirehoseClientBuilder)AmazonKinesisFirehoseClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonKinesisFirehoseClientBuilder.standard() : (AmazonKinesisFirehoseClientBuilder)AmazonKinesisFirehoseClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonKinesisFirehoseClientBuilder)clientBuilder.withRegion(this.configuration.getRegion());
        }
        client = (AmazonKinesisFirehose)clientBuilder.build();
        return client;
    }

    public AmazonKinesisFirehose getClient() {
        return this.kinesisFirehoseClient;
    }

    public KinesisFirehoseConfiguration getConfiguration() {
        return this.configuration;
    }
}

