/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.lambda;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeadLetterConfig;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.DeleteFunctionResult;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsResult;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.ListTagsRequest;
import com.amazonaws.services.lambda.model.ListTagsResult;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionRequest;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionResult;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.services.lambda.model.PublishVersionResult;
import com.amazonaws.services.lambda.model.TagResourceRequest;
import com.amazonaws.services.lambda.model.TagResourceResult;
import com.amazonaws.services.lambda.model.TracingConfig;
import com.amazonaws.services.lambda.model.UntagResourceRequest;
import com.amazonaws.services.lambda.model.UntagResourceResult;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.common.AwsExchangeUtil;
import org.apache.camel.component.aws.lambda.LambdaConfiguration;
import org.apache.camel.component.aws.lambda.LambdaEndpoint;
import org.apache.camel.component.aws.lambda.LambdaOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

public class LambdaProducer
extends DefaultProducer {
    public LambdaProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case getFunction: {
                this.getFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createFunction: {
                this.createFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteFunction: {
                this.deleteFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case invokeFunction: {
                this.invokeFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listFunctions: {
                this.listFunctions(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case updateFunction: {
                this.updateFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createEventSourceMapping: {
                this.createEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteEventSourceMapping: {
                this.deleteEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listEventSourceMapping: {
                this.listEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listTags: {
                this.listTags(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case tagResource: {
                this.tagResource(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case untagResource: {
                this.untagResource(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case publishVersion: {
                this.publishVersion(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listVersions: {
                this.listVersions(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getFunction(AWSLambda lambdaClient, Exchange exchange) {
        GetFunctionResult result;
        try {
            result = lambdaClient.getFunction(new GetFunctionRequest().withFunctionName(this.getConfiguration().getFunction()));
        }
        catch (AmazonServiceException ase) {
            this.log.trace("getFunction command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteFunction(AWSLambda lambdaClient, Exchange exchange) {
        DeleteFunctionResult result;
        try {
            result = lambdaClient.deleteFunction(new DeleteFunctionRequest().withFunctionName(this.getConfiguration().getFunction()));
        }
        catch (AmazonServiceException ase) {
            this.log.trace("deleteFunction command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listFunctions(AWSLambda lambdaClient, Exchange exchange) {
        ListFunctionsResult result;
        try {
            result = lambdaClient.listFunctions();
        }
        catch (AmazonServiceException ase) {
            this.log.trace("listFunctions command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void invokeFunction(AWSLambda lambdaClient, Exchange exchange) {
        InvokeResult result;
        try {
            InvokeRequest request = new InvokeRequest().withFunctionName(this.getConfiguration().getFunction()).withPayload((String)exchange.getIn().getBody(String.class));
            result = lambdaClient.invoke(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("invokeFunction command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)StandardCharsets.UTF_8.decode(result.getPayload()).toString());
    }

    private void createFunction(AWSLambda lambdaClient, Exchange exchange) throws Exception {
        CreateFunctionResult result;
        try {
            Map tags;
            Map environmentVariables;
            Integer timeout;
            CreateFunctionRequest request = new CreateFunctionRequest().withFunctionName(this.getConfiguration().getFunction());
            FunctionCode functionCode = new FunctionCode();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket"))) {
                String s3Bucket = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket", String.class);
                functionCode.withS3Bucket(s3Bucket);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key"))) {
                String s3Key = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Key", String.class);
                functionCode.withS3Key(s3Key);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion"))) {
                String s3ObjectVersion = (String)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion", String.class);
                functionCode.withS3ObjectVersion(s3ObjectVersion);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaZipFile"))) {
                String zipFile = (String)exchange.getIn().getHeader("CamelAwsLambdaZipFile", String.class);
                File fileLocalPath = new File(zipFile);
                FileInputStream inputStream = new FileInputStream(fileLocalPath);
                functionCode.withZipFile(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)inputStream)));
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getBody())) {
                functionCode.withZipFile((ByteBuffer)exchange.getIn().getBody(ByteBuffer.class));
            }
            if (!(ObjectHelper.isNotEmpty((Object)exchange.getIn().getBody()) || ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket")) && ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key")))) {
                throw new IllegalArgumentException("At least S3 bucket/S3 key or zip file must be specified");
            }
            request.withCode(functionCode);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaRole"))) {
                throw new IllegalArgumentException("Role must be specified");
            }
            request.withRole((String)exchange.getIn().getHeader("CamelAwsLambdaRole", String.class));
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaRuntime"))) {
                throw new IllegalArgumentException("Runtime must be specified");
            }
            request.withRuntime((String)exchange.getIn().getHeader("CamelAwsLambdaRuntime", String.class));
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaHandler"))) {
                throw new IllegalArgumentException("Handler must be specified");
            }
            request.withHandler((String)exchange.getIn().getHeader("CamelAwsLambdaHandler", String.class));
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaDescription"))) {
                String description = (String)exchange.getIn().getHeader("CamelAwsLambdaDescription", String.class);
                request.withDescription(description);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTargetArn"))) {
                String targetArn = (String)exchange.getIn().getHeader("CamelAwsLambdaTargetArn", String.class);
                request.withDeadLetterConfig(new DeadLetterConfig().withTargetArn(targetArn));
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaMemorySize"))) {
                Integer memorySize = (Integer)exchange.getIn().getHeader("CamelAwsLambdaMemorySize", Integer.class);
                request.withMemorySize(memorySize);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaKMSKeyArn"))) {
                String kmsKeyARN = (String)exchange.getIn().getHeader("CamelAwsLambdaKMSKeyArn", String.class);
                request.withKMSKeyArn(kmsKeyARN);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaPublish"))) {
                Boolean publish = (Boolean)exchange.getIn().getHeader("CamelAwsLambdaPublish", Boolean.class);
                request.withPublish(publish);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaTimeout", Integer.class);
                request.withTimeout(timeout);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTracingConfig"))) {
                String tracingConfigMode = (String)exchange.getIn().getHeader("CamelAwsLambdaTracingConfig", String.class);
                request.withTracingConfig(new TracingConfig().withMode(tracingConfigMode));
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout", Integer.class);
                request.withSdkClientExecutionTimeout(timeout.intValue());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout", Integer.class);
                request.withSdkRequestTimeout(timeout.intValue());
            }
            if ((environmentVariables = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsLambdaEnvironmentVariables", Map.class)))) != null) {
                request.withEnvironment(new Environment().withVariables(environmentVariables));
            }
            if ((tags = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsLambdaTags", Map.class)))) != null) {
                request.withTags(tags);
            }
            List securityGroupIds = CastUtils.cast((List)((List)exchange.getIn().getHeader("CamelAwsLambdaSecurityGroupIds", List.class)));
            List subnetIds = CastUtils.cast((List)((List)exchange.getIn().getHeader("CamelAwsLambdaSubnetIds", List.class)));
            if (securityGroupIds != null || subnetIds != null) {
                VpcConfig vpcConfig = new VpcConfig();
                if (securityGroupIds != null) {
                    vpcConfig.withSecurityGroupIds((Collection)securityGroupIds);
                }
                if (subnetIds != null) {
                    vpcConfig.withSubnetIds((Collection)subnetIds);
                }
                request.withVpcConfig(vpcConfig);
            }
            result = lambdaClient.createFunction(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("createFunction command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateFunction(AWSLambda lambdaClient, Exchange exchange) throws Exception {
        UpdateFunctionCodeResult result;
        try {
            Integer timeout;
            UpdateFunctionCodeRequest request = new UpdateFunctionCodeRequest().withFunctionName(this.getConfiguration().getFunction());
            FunctionCode functionCode = new FunctionCode();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket"))) {
                String s3Bucket = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket", String.class);
                functionCode.withS3Bucket(s3Bucket);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key"))) {
                String s3Key = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Key", String.class);
                functionCode.withS3Key(s3Key);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion"))) {
                String s3ObjectVersion = (String)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion", String.class);
                functionCode.withS3ObjectVersion(s3ObjectVersion);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaZipFile"))) {
                String zipFile = (String)exchange.getIn().getHeader("CamelAwsLambdaZipFile", String.class);
                File fileLocalPath = new File(zipFile);
                FileInputStream inputStream = new FileInputStream(fileLocalPath);
                functionCode.withZipFile(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)inputStream)));
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getBody())) {
                functionCode.withZipFile((ByteBuffer)exchange.getIn().getBody(ByteBuffer.class));
            }
            if (ObjectHelper.isEmpty((Object)exchange.getIn().getBody()) && ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket")) && ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key"))) {
                throw new IllegalArgumentException("At least S3 bucket/S3 key or zip file must be specified");
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaPublish"))) {
                Boolean publish = (Boolean)exchange.getIn().getHeader("CamelAwsLambdaPublish", Boolean.class);
                request.withPublish(publish);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout", Integer.class);
                request.withSdkClientExecutionTimeout(timeout.intValue());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout", Integer.class);
                request.withSdkRequestTimeout(timeout.intValue());
            }
            result = lambdaClient.updateFunctionCode(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("updateFunction command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createEventSourceMapping(AWSLambda lambdaClient, Exchange exchange) {
        CreateEventSourceMappingResult result;
        try {
            Integer timeout;
            CreateEventSourceMappingRequest request = new CreateEventSourceMappingRequest().withFunctionName(this.getConfiguration().getFunction());
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceArn"))) {
                throw new IllegalArgumentException("Event Source Arn must be specified");
            }
            request.withEventSourceArn((String)exchange.getIn().getHeader("CamelAwsLambdaEventSourceArn", String.class));
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceBatchSize"))) {
                Integer batchSize = (Integer)exchange.getIn().getHeader("CamelAwsLambdaEventSourceBatchSize", Integer.class);
                request.withBatchSize(batchSize);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout", Integer.class);
                request.withSdkClientExecutionTimeout(timeout.intValue());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout", Integer.class);
                request.withSdkRequestTimeout(timeout.intValue());
            }
            result = lambdaClient.createEventSourceMapping(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("createEventSourceMapping command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteEventSourceMapping(AWSLambda lambdaClient, Exchange exchange) {
        DeleteEventSourceMappingResult result;
        try {
            Integer timeout;
            DeleteEventSourceMappingRequest request = new DeleteEventSourceMappingRequest();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceUuid"))) {
                throw new IllegalArgumentException("Event Source Arn must be specified");
            }
            request.withUUID((String)exchange.getIn().getHeader("CamelAwsLambdaEventSourceUuid", String.class));
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout", Integer.class);
                request.withSdkClientExecutionTimeout(timeout.intValue());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout", Integer.class);
                request.withSdkRequestTimeout(timeout.intValue());
            }
            result = lambdaClient.deleteEventSourceMapping(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("deleteEventSourceMapping command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listEventSourceMapping(AWSLambda lambdaClient, Exchange exchange) {
        ListEventSourceMappingsResult result;
        try {
            Integer timeout;
            ListEventSourceMappingsRequest request = new ListEventSourceMappingsRequest().withFunctionName(this.getConfiguration().getFunction());
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkClientExecutionTimeout", Integer.class);
                request.withSdkClientExecutionTimeout(timeout.intValue());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout"))) {
                timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaSdkRequestTimeout", Integer.class);
                request.withSdkRequestTimeout(timeout.intValue());
            }
            result = lambdaClient.listEventSourceMappings(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("listEventSourceMapping command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listTags(AWSLambda lambdaClient, Exchange exchange) {
        ListTagsResult result;
        try {
            ListTagsRequest request = new ListTagsRequest();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                throw new IllegalArgumentException("The resource ARN must be specified");
            }
            String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
            request.withResource(resource);
            result = lambdaClient.listTags(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("listTags command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void tagResource(AWSLambda lambdaClient, Exchange exchange) {
        TagResourceResult result;
        try {
            TagResourceRequest request = new TagResourceRequest();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                throw new IllegalArgumentException("The resource ARN must be specified");
            }
            String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
            request.withResource(resource);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceTags"))) {
                throw new IllegalArgumentException("The tags must be specified");
            }
            Map tags = (Map)exchange.getIn().getHeader("CamelAwsLambdaResourceTags", Map.class);
            request.withTags(tags);
            result = lambdaClient.tagResource(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("listTags command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void untagResource(AWSLambda lambdaClient, Exchange exchange) {
        UntagResourceResult result;
        try {
            UntagResourceRequest request = new UntagResourceRequest();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                throw new IllegalArgumentException("The resource ARN must be specified");
            }
            String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
            request.withResource(resource);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceTagKeys"))) {
                throw new IllegalArgumentException("The tag keys must be specified");
            }
            List tagKeys = (List)exchange.getIn().getHeader("CamelAwsLambdaResourceTagKeys", List.class);
            request.withTagKeys((Collection)tagKeys);
            result = lambdaClient.untagResource(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("untagResource command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void publishVersion(AWSLambda lambdaClient, Exchange exchange) {
        PublishVersionResult result;
        try {
            PublishVersionRequest request = new PublishVersionRequest().withFunctionName(this.getConfiguration().getFunction());
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaVersionDescription"))) {
                String description = (String)exchange.getIn().getHeader("CamelAwsLambdaVersionDescription", String.class);
                request.withDescription(description);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaVersionRevisionId"))) {
                String revisionId = (String)exchange.getIn().getHeader("CamelAwsLambdaVersionRevisionId", String.class);
                request.withRevisionId(revisionId);
            }
            result = lambdaClient.publishVersion(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("publishVersion command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listVersions(AWSLambda lambdaClient, Exchange exchange) {
        ListVersionsByFunctionResult result;
        try {
            ListVersionsByFunctionRequest request = new ListVersionsByFunctionRequest().withFunctionName(this.getConfiguration().getFunction());
            result = lambdaClient.listVersionsByFunction(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("publishVersion command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private LambdaOperations determineOperation(Exchange exchange) {
        LambdaOperations operation = (LambdaOperations)((Object)exchange.getIn().getHeader("CamelAwsLambdaOperation", LambdaOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected LambdaConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public LambdaEndpoint getEndpoint() {
        return (LambdaEndpoint)super.getEndpoint();
    }
}

