/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageNotInflightException;
import com.amazonaws.services.sqs.model.QueueDeletedRecentlyException;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import com.amazonaws.services.sqs.model.ReceiptHandleIsInvalidException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class SqsConsumer
extends ScheduledBatchPollingConsumer {
    private ScheduledExecutorService scheduledExecutor;
    private transient String sqsConsumerToString;
    private Collection<String> attributeNames;
    private Collection<String> messageAttributeNames;

    public SqsConsumer(SqsEndpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
        String[] names;
        if (this.getConfiguration().getAttributeNames() != null) {
            names = this.getConfiguration().getAttributeNames().split(",");
            this.attributeNames = Arrays.asList(names);
        }
        if (this.getConfiguration().getMessageAttributeNames() != null) {
            names = this.getConfiguration().getMessageAttributeNames().split(",");
            this.messageAttributeNames = Arrays.asList(names);
        }
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        ReceiveMessageRequest request = new ReceiveMessageRequest(this.getQueueUrl());
        request.setMaxNumberOfMessages(this.getMaxMessagesPerPoll() > 0 ? Integer.valueOf(this.getMaxMessagesPerPoll()) : null);
        request.setVisibilityTimeout(this.getConfiguration().getVisibilityTimeout() != null ? this.getConfiguration().getVisibilityTimeout() : null);
        request.setWaitTimeSeconds(this.getConfiguration().getWaitTimeSeconds() != null ? this.getConfiguration().getWaitTimeSeconds() : null);
        if (this.attributeNames != null) {
            request.setAttributeNames(this.attributeNames);
        }
        if (this.messageAttributeNames != null) {
            request.setMessageAttributeNames(this.messageAttributeNames);
        }
        this.log.trace("Receiving messages with request [{}]...", (Object)request);
        ReceiveMessageResult messageResult = null;
        try {
            messageResult = this.getClient().receiveMessage(request);
        }
        catch (QueueDoesNotExistException e) {
            this.log.info("Queue does not exist....recreating now...");
            this.reConnectToQueue();
            messageResult = this.getClient().receiveMessage(request);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received {} messages", (Object)messageResult.getMessages().size());
        }
        Queue<Exchange> exchanges = this.createExchanges(messageResult.getMessages());
        return this.processBatch(CastUtils.cast(exchanges));
    }

    public void reConnectToQueue() {
        try {
            this.getEndpoint().createQueue(this.getClient());
        }
        catch (QueueDeletedRecentlyException qdr) {
            this.log.debug("Queue recently deleted, will retry in 30 seconds.");
            try {
                Thread.sleep(30000L);
                this.getEndpoint().createQueue(this.getClient());
            }
            catch (Exception e) {
                this.log.warn("failed to retry queue connection.", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.log.warn("Could not connect to queue in amazon.", (Throwable)e);
        }
    }

    protected Queue<Exchange> createExchanges(List<Message> messages) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received {} messages in this poll", (Object)messages.size());
        }
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        for (Message message : messages) {
            Exchange exchange = this.getEndpoint().createExchange(message);
            answer.add(exchange);
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            final Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            Integer visibilityTimeout = this.getConfiguration().getVisibilityTimeout();
            if (this.scheduledExecutor != null && visibilityTimeout != null && visibilityTimeout / 2 > 0) {
                int delay = visibilityTimeout / 2;
                int period = visibilityTimeout;
                int repeatSeconds = Double.valueOf(visibilityTimeout.doubleValue() * 1.5).intValue();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Scheduled TimeoutExtender task to start after {} delay, and run with {}/{} period/repeat (seconds), to extend exchangeId: {}", new Object[]{delay, period, repeatSeconds, exchange.getExchangeId()});
                }
                final ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.scheduleAtFixedRate(new TimeoutExtender(exchange, repeatSeconds), delay, period, TimeUnit.SECONDS);
                exchange.addOnCompletion(new Synchronization(){

                    public void onComplete(Exchange exchange) {
                        this.cancelExtender(exchange);
                    }

                    public void onFailure(Exchange exchange) {
                        this.cancelExtender(exchange);
                    }

                    private void cancelExtender(Exchange exchange) {
                        SqsConsumer.this.log.trace("Processing done so cancelling TimeoutExtender task for exchangeId: {}", (Object)exchange.getExchangeId());
                        scheduledFuture.cancel(true);
                    }
                });
            }
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    SqsConsumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    SqsConsumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "SqsConsumerOnCompletion";
                }
            });
            this.log.trace("Processing exchange [{}]...", (Object)exchange);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    SqsConsumer.this.log.trace("Processing exchange [{}] done.", (Object)exchange);
                }
            });
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            if (this.shouldDelete(exchange)) {
                String receiptHandle = (String)exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class);
                DeleteMessageRequest deleteRequest = new DeleteMessageRequest(this.getQueueUrl(), receiptHandle);
                this.log.trace("Deleting message with receipt handle {}...", (Object)receiptHandle);
                this.getClient().deleteMessage(deleteRequest);
                this.log.trace("Deleted message with receipt handle {}...", (Object)receiptHandle);
            }
        }
        catch (AmazonClientException e) {
            this.getExceptionHandler().handleException("Error occurred during deleting message. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    private boolean shouldDelete(Exchange exchange) {
        boolean shouldDeleteByFilter = exchange.getProperty("CamelFilterMatched") != null && this.getConfiguration().isDeleteIfFiltered() && this.passedThroughFilter(exchange);
        return this.getConfiguration().isDeleteAfterRead() || shouldDeleteByFilter;
    }

    private boolean passedThroughFilter(Exchange exchange) {
        return (Boolean)exchange.getProperty("CamelFilterMatched", (Object)false, Boolean.class);
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange. Will attempt to process the message on next poll.", exchange, (Throwable)cause);
        }
    }

    protected SqsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected AmazonSQS getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    public SqsEndpoint getEndpoint() {
        return (SqsEndpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.sqsConsumerToString == null) {
            this.sqsConsumerToString = "SqsConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sqsConsumerToString;
    }

    protected void doStart() throws Exception {
        if (this.getConfiguration().isExtendMessageVisibility() && this.scheduledExecutor == null) {
            this.scheduledExecutor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "SqsTimeoutExtender");
        }
        super.doStart();
    }

    protected void doShutdown() throws Exception {
        if (this.scheduledExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutor);
            this.scheduledExecutor = null;
        }
        super.doShutdown();
    }

    private class TimeoutExtender
    implements Runnable {
        private final Exchange exchange;
        private final int repeatSeconds;

        TimeoutExtender(Exchange exchange, int repeatSeconds) {
            this.exchange = exchange;
            this.repeatSeconds = repeatSeconds;
        }

        @Override
        public void run() {
            ChangeMessageVisibilityRequest request = new ChangeMessageVisibilityRequest(SqsConsumer.this.getQueueUrl(), (String)this.exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class), Integer.valueOf(this.repeatSeconds));
            try {
                SqsConsumer.this.log.trace("Extending visibility window by {} seconds for exchange {}", (Object)this.repeatSeconds, (Object)this.exchange);
                SqsConsumer.this.getEndpoint().getClient().changeMessageVisibility(request);
                SqsConsumer.this.log.debug("Extended visibility window by {} seconds for exchange {}", (Object)this.repeatSeconds, (Object)this.exchange);
            }
            catch (ReceiptHandleIsInvalidException receiptHandleIsInvalidException) {
            }
            catch (MessageNotInflightException messageNotInflightException) {
            }
            catch (Exception e) {
                SqsConsumer.this.log.warn("Extending visibility window failed for exchange " + this.exchange + ". Will not attempt to extend visibility further. This exception will be ignored.", (Throwable)e);
            }
        }
    }
}

