/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.Athena2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.AthenaClientBuilder;

@UriEndpoint(firstVersion="3.4.0", scheme="aws2-athena", title="AWS 2 Athena", syntax="aws2-athena:label", producerOnly=true, category={Category.CLOUD, Category.DATABASE})
public class Athena2Endpoint
extends DefaultEndpoint {
    private AthenaClient athenaClient;
    @UriParam
    private Athena2Configuration configuration;

    public Athena2Endpoint(String uri, Component component, Athena2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Athena2Producer((Endpoint)this);
    }

    public void doInit() throws Exception {
        super.doInit();
        this.athenaClient = this.configuration.getAmazonAthenaClient() != null ? this.configuration.getAmazonAthenaClient() : this.createAthenaClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonAthenaClient()) && this.athenaClient != null) {
            this.athenaClient.close();
        }
        super.doStop();
    }

    public Athena2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Athena2Configuration configuration) {
        this.configuration = configuration;
    }

    public AthenaClient getAthenaClient() {
        return this.athenaClient;
    }

    public void setAthenaClient(AthenaClient athenaClient) {
        this.athenaClient = athenaClient;
    }

    AthenaClient createAthenaClient() {
        AthenaClient client = null;
        AthenaClientBuilder clientBuilder = AthenaClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (AthenaClientBuilder)((AthenaClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (AthenaClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (AthenaClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AthenaClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (AthenaClient)clientBuilder.build();
        return client;
    }
}

