/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.athena.Athena2Component;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.Athena2Constants;
import org.apache.camel.component.aws2.athena.Athena2Producer;
import org.apache.camel.component.aws2.athena.client.Athena2ClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.athena.AthenaClient;

@UriEndpoint(firstVersion="3.4.0", scheme="aws2-athena", title="AWS Athena", syntax="aws2-athena:label", producerOnly=true, category={Category.CLOUD, Category.DATABASE}, headersClass=Athena2Constants.class)
public class Athena2Endpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private AthenaClient athenaClient;
    @UriParam
    private Athena2Configuration configuration;

    public Athena2Endpoint(String uri, Component component, Athena2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Athena2Producer((Endpoint)this);
    }

    public Athena2Component getComponent() {
        return (Athena2Component)super.getComponent();
    }

    public void doInit() throws Exception {
        super.doInit();
        this.athenaClient = this.configuration.getAmazonAthenaClient() != null ? this.configuration.getAmazonAthenaClient() : Athena2ClientFactory.getAWSAthenaClient(this.configuration).getAthenaClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonAthenaClient()) && this.athenaClient != null) {
            this.athenaClient.close();
        }
        super.doStop();
    }

    public Athena2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Athena2Configuration configuration) {
        this.configuration = configuration;
    }

    public AthenaClient getAthenaClient() {
        return this.athenaClient;
    }

    public void setAthenaClient(AthenaClient athenaClient) {
        this.athenaClient = athenaClient;
    }

    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            return this.configuration.getRegion();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "athena";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getDatabase() != null) {
            return Map.of("database", this.configuration.getDatabase());
        }
        return null;
    }
}

