/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import org.apache.camel.spi.Metadata;

public interface Athena2Constants {
    @Metadata(label="all", description="The operation to perform. Permitted values are getQueryExecution, getQueryResults, listQueryExecutions, startQueryExecution.", javaType="org.apache.camel.component.aws2.athena.Athena2Operations", defaultValue="startQueryExecution")
    public static final String OPERATION = "CamelAwsAthenaOperation";
    @Metadata(label="startQueryExecution", description="The Athena database to use.", javaType="String")
    public static final String DATABASE = "CamelAwsAthenaDatabase";
    @Metadata(label="getQueryExecution getQueryResults startQueryExecution", description="The unique ID identifying the query execution.", javaType="String")
    public static final String QUERY_EXECUTION_ID = "CamelAwsAthenaQueryExecutionId";
    @Metadata(label="listQueryExecutions startQueryExecution", description="The workgroup to use for running the query.", javaType="String")
    public static final String WORK_GROUP = "CamelAwsAthenaWorkGroup";
    @Metadata(label="getQueryResults listQueryExecutions", description="Pagination token to use in the case where the response from the previous request was truncated.", javaType="String")
    public static final String NEXT_TOKEN = "CamelAwsAthenaNextToken";
    @Metadata(label="getQueryResults listQueryExecutions", description="Max number of results to return for the given operation (if supported by the Athena API endpoint).\nIf not set, will use the Athena API default for the given operation.", javaType="Integer")
    public static final String MAX_RESULTS = "CamelAwsAthenaMaxResults";
    @Metadata(label="startQueryExecution", description="Include useful trace information at the beginning of queries as an SQL comment (prefixed with \"--\").", javaType="boolean")
    public static final String INCLUDE_TRACE = "CamelAwsAthenaIncludeTrace";
    @Metadata(label="getQueryExecution getQueryResults startQueryExecution", description="The location in Amazon S3 where query results are stored, such as s3://path/to/query/bucket/.\nEnsure this value ends with a forward slash ('/').", javaType="String")
    public static final String OUTPUT_LOCATION = "CamelAwsAthenaOutputLocation";
    @Metadata(label="getQueryResults", description="How query results should be returned.  One of\nStreamList (default - return a GetQueryResultsIterable that can page through all results),\nSelectList (returns at most 1,000 rows at a time, plus a NextToken value as a header than can be used for manual pagination of results),\nS3Pointer (return an S3 path pointing to the results).", javaType="org.apache.camel.component.aws2.athena.Athena2OutputType")
    public static final String OUTPUT_TYPE = "CamelAwsAthenaOutputType";
    @Metadata(label="getQueryExecution getQueryResults startQueryExecution", description="The state of the query execution.", javaType="software.amazon.awssdk.services.athena.model.QueryExecutionState")
    public static final String QUERY_EXECUTION_STATE = "CamelAwsAthenaQueryExecutionState";
    @Metadata(label="startQueryExecution", description="A unique string to ensure issues queries are idempotent.  It is unlikely you will need to set this.", javaType="String")
    public static final String CLIENT_REQUEST_TOKEN = "CamelAwsAthenaClientRequestToken";
    @Metadata(label="startQueryExecution", description="The SQL query to run.  Except for simple queries, prefer setting this as the `body` of the\nExchange or as this header to avoid having to deal with URL encoding issues.", javaType="String")
    public static final String QUERY_STRING = "CamelAwsAthenaQueryString";
    @Metadata(label="startQueryExecution", description="The encryption type to use when storing query results in S3.", javaType="software.amazon.awssdk.services.athena.model.EncryptionOption")
    public static final String ENCRYPTION_OPTION = "CamelAwsAthenaEncryptionOption";
    @Metadata(label="startQueryExecution", description="For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.", javaType="String")
    public static final String KMS_KEY = "CamelAwsAthenaKmsKey";
    @Metadata(label="startQueryExecution", description="Optional max wait time in millis to wait for a successful query completion.\nSee the section 'Waiting for Query Completion and Retrying Failed Queries' to learn more.", javaType="long")
    public static final String WAIT_TIMEOUT = "CamelAwsAthenaWaitTimeout";
    @Metadata(label="startQueryExecution", description="Milliseconds before the first poll for query execution status.\nSee the section 'Waiting for Query Completion and Retrying Failed Queries' to learn more.", javaType="long")
    public static final String INITIAL_DELAY = "CamelAwsAthenaInitialDelay";
    @Metadata(label="startQueryExecution", description="Milliseconds before the next poll for query execution status.\nSee the section 'Waiting for Query Completion and Retrying Failed Queries' to learn more.", javaType="long")
    public static final String DELAY = "CamelAwsAthenaDelay";
    @Metadata(label="startQueryExecution", description="Maximum number of times to attempt a query.  Set to 1 to disable retries.\nSee the section 'Waiting for Query Completion and Retrying Failed Queries' to learn more.", javaType="int")
    public static final String MAX_ATTEMPTS = "CamelAwsAthenaMaxAttempts";
    @Metadata(label="startQueryExecution", description="Optional comma separated list of error types to retry the query for.  Use\n'retryable' to retry all retryable failure conditions (e.g. generic errors and resources exhausted),\n'generic' to retry 'GENERIC_INTERNAL_ERROR' failures,\n'exhausted' to retry queries that have exhausted resource limits,\n'always' to always retry regardless of failure condition, or\n'never' or null to never retry (default).\nSee the section 'Waiting for Query Completion and Retrying Failed Queries' to learn more.", javaType="String")
    public static final String RETRY = "CamelAwsAthenaRetry";
    @Metadata(label="startQueryExecution", description="Reset the waitTimeout countdown in the event of a query retry.\nIf set to true, potential max time spent waiting for queries is equal to waitTimeout x maxAttempts.\nSee the section 'Waiting for Query Completion and Retrying Failed Queries' to learn more.", javaType="boolean")
    public static final String RESET_WAIT_TIMEOUT_ON_RETRY = "CamelAwsAthenaResetWaitTimeoutOnRetry";
    @Metadata(label="startQueryExecution", description="Total number of attempts made to run the query.  Will be greater than 1 if the query is retried.", javaType="int")
    public static final String START_QUERY_EXECUTION_ATTEMPTS = "CamelAwsAthenaStartQueryExecutionAttempts";
    @Metadata(label="startQueryExecution", description="Total time in millis taken in startQueryExecution (mostly relevant when waiting for query completion within startQueryExecution).", javaType="long")
    public static final String START_QUERY_EXECUTION_ELAPSED_MILLIS = "CamelAwsAthenaStartQueryExecutionElapsedMillis";
}

