/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.cw.Cw2ComponentVerifierExtension;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.component.aws2.cw.Cw2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;

@org.apache.camel.spi.annotations.Component(value="aws2-cw")
public class Cw2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private Cw2Configuration configuration;

    public Cw2Component() {
        this(null);
    }

    public Cw2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Cw2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Metric namespace must be specified.");
        }
        Cw2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Cw2Configuration();
        configuration.setNamespace(remaining);
        Cw2Endpoint endpoint = new Cw2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonCwClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonCwClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Cw2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Cw2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(Cw2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(CloudWatchClient.class);
        if (clients.size() == 1) {
            configuration.setAmazonCwClient((CloudWatchClient)clients.stream().findFirst().get());
        }
    }
}

