/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw;

import java.net.URI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.component.aws2.cw.Cw2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-cw", title="AWS 2 CloudWatch", syntax="aws2-cw:namespace", producerOnly=true, label="cloud,monitoring")
public class Cw2Endpoint
extends DefaultEndpoint {
    @UriParam
    private Cw2Configuration configuration;
    private CloudWatchClient cloudWatchClient;

    public Cw2Endpoint(String uri, Component component, Cw2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Cw2Producer((Endpoint)this);
    }

    public void doInit() throws Exception {
        super.doInit();
        this.cloudWatchClient = this.configuration.getAmazonCwClient() != null ? this.configuration.getAmazonCwClient() : this.createCloudWatchClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonCwClient()) && this.cloudWatchClient != null) {
            this.cloudWatchClient.close();
        }
        super.doStop();
    }

    public Cw2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Cw2Configuration configuration) {
        this.configuration = configuration;
    }

    public void setCloudWatchClient(CloudWatchClient cloudWatchClient) {
        this.cloudWatchClient = cloudWatchClient;
    }

    public CloudWatchClient getCloudWatchClient() {
        return this.cloudWatchClient;
    }

    CloudWatchClient createCloudWatchClient() {
        CloudWatchClient client = null;
        CloudWatchClientBuilder clientBuilder = CloudWatchClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + this.configuration.getProxyHost() + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (CloudWatchClientBuilder)((CloudWatchClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (CloudWatchClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (CloudWatchClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (CloudWatchClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (CloudWatchClient)clientBuilder.build();
        return client;
    }
}

