/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw;

import java.time.Instant;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.cw.Cw2Component;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;

public class Cw2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Cw2Configuration getOrCreateConfiguration(Cw2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Cw2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Cw2Component target = (Cw2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazoncwclient": 
            case "amazonCwClient": {
                this.getOrCreateConfiguration(target).setAmazonCwClient((CloudWatchClient)Cw2ComponentConfigurer.property((CamelContext)camelContext, CloudWatchClient.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)Cw2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Cw2Configuration)Cw2ComponentConfigurer.property((CamelContext)camelContext, Cw2Configuration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Cw2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "name": {
                this.getOrCreateConfiguration(target).setName((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)Cw2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Cw2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Cw2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "timestamp": {
                this.getOrCreateConfiguration(target).setTimestamp((Instant)Cw2ComponentConfigurer.property((CamelContext)camelContext, Instant.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)Cw2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "unit": {
                this.getOrCreateConfiguration(target).setUnit((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "value": {
                this.getOrCreateConfiguration(target).setValue((Double)Cw2ComponentConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"amazonCwClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "amazoncwclient": 
            case "amazonCwClient": {
                return CloudWatchClient.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return Cw2Configuration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "name": {
                return String.class;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "timestamp": {
                return Instant.class;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
            case "unit": {
                return String.class;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return String.class;
            }
            case "value": {
                return Double.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Cw2Component target = (Cw2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazoncwclient": 
            case "amazonCwClient": {
                return this.getOrCreateConfiguration(target).getAmazonCwClient();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "name": {
                return this.getOrCreateConfiguration(target).getName();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "timestamp": {
                return this.getOrCreateConfiguration(target).getTimestamp();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
            case "unit": {
                return this.getOrCreateConfiguration(target).getUnit();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
            case "value": {
                return this.getOrCreateConfiguration(target).getValue();
            }
        }
        return null;
    }
}

