/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.component.aws2.cw.Cw2Endpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

public class Cw2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Cw2Producer.class);
    private transient String cwProducerToString;

    public Cw2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        List<MetricDatum> metricData = this.getMetricData(exchange);
        PutMetricDataRequest.Builder builder = PutMetricDataRequest.builder();
        builder.metricData(metricData).namespace(this.determineNameSpace(exchange));
        PutMetricDataRequest request = (PutMetricDataRequest)builder.build();
        LOG.info("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        this.getEndpoint().getCloudWatchClient().putMetricData(request);
    }

    private List<MetricDatum> getMetricData(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body instanceof List) {
            return CastUtils.cast((List)((List)body));
        }
        if (body instanceof MetricDatum) {
            return Arrays.asList((MetricDatum)body);
        }
        MetricDatum.Builder metricDatum = MetricDatum.builder().metricName(this.determineName(exchange)).value(this.determineValue(exchange)).unit(this.determineUnit(exchange)).timestamp(this.determineTimestamp(exchange));
        this.setDimension(metricDatum, exchange);
        return Arrays.asList((MetricDatum)metricDatum.build());
    }

    private void setDimension(MetricDatum.Builder metricDatum, Exchange exchange) {
        String name = (String)exchange.getIn().getHeader("CamelAwsCwMetricDimensionName", String.class);
        String value = (String)exchange.getIn().getHeader("CamelAwsCwMetricDimensionValue", String.class);
        if (name != null && value != null) {
            metricDatum.dimensions(new Dimension[]{(Dimension)Dimension.builder().name(name).value(value).build()});
        } else {
            Map dimensions = (Map)exchange.getIn().getHeader("CamelAwsCwMetricDimensions", Map.class);
            if (dimensions != null) {
                ArrayList<Dimension> dimensionCollection = new ArrayList<Dimension>();
                for (Map.Entry dimensionEntry : dimensions.entrySet()) {
                    Dimension dimension = (Dimension)Dimension.builder().name((String)dimensionEntry.getKey()).value((String)dimensionEntry.getValue()).build();
                    dimensionCollection.add(dimension);
                }
                metricDatum.dimensions(dimensionCollection);
            }
        }
    }

    private Instant determineTimestamp(Exchange exchange) {
        Instant timestamp = (Instant)exchange.getIn().getHeader("CamelAwsCwMetricTimestamp", Instant.class);
        if (timestamp == null) {
            timestamp = this.getConfiguration().getTimestamp();
        }
        return timestamp;
    }

    private String determineNameSpace(Exchange exchange) {
        String namespace = (String)exchange.getIn().getHeader("CamelAwsCwMetricNamespace", String.class);
        if (namespace == null) {
            namespace = this.getConfiguration().getNamespace();
        }
        return namespace;
    }

    private String determineName(Exchange exchange) {
        String name = (String)exchange.getIn().getHeader("CamelAwsCwMetricName", String.class);
        if (name == null) {
            name = this.getConfiguration().getName();
        }
        return name;
    }

    private Double determineValue(Exchange exchange) {
        Double value = (Double)exchange.getIn().getHeader("CamelAwsCwMetricValue", Double.class);
        if (value == null) {
            value = this.getConfiguration().getValue();
        }
        return value != null ? value : Double.valueOf(1.0);
    }

    private StandardUnit determineUnit(Exchange exchange) {
        String unit = (String)exchange.getIn().getHeader("CamelAwsCwMetricUnit", String.class);
        if (unit == null) {
            unit = this.getConfiguration().getUnit();
        }
        return unit != null ? StandardUnit.fromValue((String)unit) : StandardUnit.COUNT;
    }

    protected Cw2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.cwProducerToString == null) {
            this.cwProducerToString = "CwProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.cwProducerToString;
    }

    public Cw2Endpoint getEndpoint() {
        return (Cw2Endpoint)super.getEndpoint();
    }
}

