/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

public class BatchGetItemsCommand
extends AbstractDdbCommand {
    public BatchGetItemsCommand(DynamoDbClient ddbClient, Ddb2Configuration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        BatchGetItemResponse result = this.ddbClient.batchGetItem((BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(this.determineBatchItems()).build());
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("CamelAwsDdbBatchResponse", result.responses());
        tmp.put("CamelAwsDdbUnprocessedKeys", result.unprocessedKeys());
        this.addToResults(tmp);
    }

    private Map<String, KeysAndAttributes> determineBatchItems() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbBatchItems", Map.class);
    }
}

