/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.net.URI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import org.apache.camel.component.aws2.ddb.Ddb2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ddb", title="AWS 2 DynamoDB", syntax="aws2-ddb:tableName", producerOnly=true, label="cloud,database,nosql")
public class Ddb2Endpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(Ddb2Endpoint.class);
    @UriParam
    private Ddb2Configuration configuration;
    private DynamoDbClient ddbClient;

    public Ddb2Endpoint(String uri, Component component, Ddb2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Ddb2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ddbClient = this.configuration.getAmazonDDBClient() != null ? this.configuration.getAmazonDDBClient() : this.createDdbClient();
        String tableName = this.getConfiguration().getTableName();
        LOG.trace("Querying whether table [{}] already exists...", (Object)tableName);
        try {
            DescribeTableRequest.Builder request = DescribeTableRequest.builder().tableName(tableName);
            TableDescription tableDescription = this.ddbClient.describeTable((DescribeTableRequest)request.build()).table();
            if (!this.isTableActive(tableDescription)) {
                this.waitForTableToBecomeAvailable(tableName);
            }
            LOG.trace("Table [{}] already exists", (Object)tableName);
            return;
        }
        catch (ResourceNotFoundException e) {
            LOG.trace("Table [{}] doesn't exist yet", (Object)tableName);
            LOG.trace("Creating table [{}]...", (Object)tableName);
            TableDescription tableDescription = this.createTable(tableName);
            if (!this.isTableActive(tableDescription)) {
                this.waitForTableToBecomeAvailable(tableName);
            }
            LOG.trace("Table [{}] created", (Object)tableName);
            return;
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonDDBClient()) && this.ddbClient != null) {
            this.ddbClient.close();
        }
        super.doStop();
    }

    private TableDescription createTable(String tableName) {
        CreateTableRequest.Builder createTableRequest = CreateTableRequest.builder().tableName(tableName).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(this.configuration.getKeyAttributeName()).keyType(this.configuration.getKeyAttributeType()).build()}).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.configuration.getReadCapacity()).writeCapacityUnits(this.configuration.getWriteCapacity()).build());
        return this.getDdbClient().createTable((CreateTableRequest)createTableRequest.build()).tableDescription();
    }

    public Ddb2Configuration getConfiguration() {
        return this.configuration;
    }

    public DynamoDbClient getDdbClient() {
        return this.ddbClient;
    }

    DynamoDbClient createDdbClient() {
        DynamoDbClient client = null;
        DynamoDbClientBuilder clientBuilder = DynamoDbClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + this.configuration.getProxyHost() + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (DynamoDbClientBuilder)((DynamoDbClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (DynamoDbClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (DynamoDbClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (DynamoDbClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (DynamoDbClient)clientBuilder.build();
        return client;
    }

    private void waitForTableToBecomeAvailable(String tableName) {
        LOG.trace("Waiting for [{}] to become ACTIVE...", (Object)tableName);
        long waitTime = 300000L;
        while (waitTime > 0L) {
            try {
                Thread.sleep(5000L);
                waitTime -= 5000L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                DescribeTableRequest request = (DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build();
                TableDescription tableDescription = this.getDdbClient().describeTable(request).table();
                if (this.isTableActive(tableDescription)) {
                    LOG.trace("Table [{}] became active", (Object)tableName);
                    return;
                }
                LOG.trace("Table [{}] not active yet", (Object)tableName);
            }
            catch (AwsServiceException ase) {
                if (ase.getMessage().contains("ResourceNotFoundException")) continue;
                throw ase;
            }
        }
        throw new RuntimeException("Table " + tableName + " never went active");
    }

    private boolean isTableActive(TableDescription tableDescription) {
        return tableDescription.tableStatus().toString().equals(TableStatus.ACTIVE.toString());
    }
}

