/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ScanCommand
extends AbstractDdbCommand {
    public ScanCommand(DynamoDbClient ddbClient, Ddb2Configuration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        ScanResponse result = this.ddbClient.scan((ScanRequest)ScanRequest.builder().tableName(this.determineTableName()).limit(this.determineLimit()).exclusiveStartKey(this.determineExclusiveStartKey()).scanFilter(this.determineScanFilter()).build());
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("CamelAwsDdbItems", result.items());
        tmp.put("CamelAwsDdbLastEvaluatedKey", result.lastEvaluatedKey());
        tmp.put("CamelAwsDdbConsumedCapacity", result.consumedCapacity());
        tmp.put("CamelAwsDdbCount", result.count());
        tmp.put("CamelAwsDdbScannedCount", result.scannedCount());
        this.addToResults(tmp);
    }

    private Map<String, Condition> determineScanFilter() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbScanFilter", Map.class);
    }
}

