/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.math.BigInteger;
import org.apache.camel.component.aws2.ddbstream.BigIntComparisons;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamEndpoint;
import org.apache.camel.component.aws2.ddbstream.ShardList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;

class ShardIteratorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShardIteratorHandler.class);
    private final Ddb2StreamEndpoint endpoint;
    private final ShardList shardList = new ShardList();
    private String currentShardIterator;
    private Shard currentShard;

    ShardIteratorHandler(Ddb2StreamEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    String getShardIterator(String resumeFromSequenceNumber) {
        ShardIteratorType iteratorType = this.getEndpoint().getConfiguration().getIteratorType();
        String sequenceNumber = this.getEndpoint().getSequenceNumber();
        if (resumeFromSequenceNumber != null) {
            this.currentShard = null;
            this.currentShardIterator = null;
            iteratorType = ShardIteratorType.AFTER_SEQUENCE_NUMBER;
            sequenceNumber = resumeFromSequenceNumber;
        }
        if (this.currentShardIterator == null) {
            ListStreamsResponse streamsListResult = this.getClient().listStreams((ListStreamsRequest)ListStreamsRequest.builder().tableName(this.getEndpoint().getConfiguration().getTableName()).build());
            String streamArn = ((Stream)streamsListResult.streams().get(0)).streamArn();
            DescribeStreamResponse streamDescriptionResult = this.getClient().describeStream((DescribeStreamRequest)DescribeStreamRequest.builder().streamArn(streamArn).build());
            this.shardList.addAll(streamDescriptionResult.streamDescription().shards());
            LOG.trace("Current shard is: {} (in {})", (Object)this.currentShard, (Object)this.shardList);
            this.currentShard = this.currentShard == null ? this.resolveNewShard(iteratorType, resumeFromSequenceNumber) : this.shardList.nextAfter(this.currentShard);
            this.shardList.removeOlderThan(this.currentShard);
            LOG.trace("Next shard is: {} (in {})", (Object)this.currentShard, (Object)this.shardList);
            GetShardIteratorResponse result = this.getClient().getShardIterator(this.buildGetShardIteratorRequest(streamArn, iteratorType, sequenceNumber));
            this.currentShardIterator = result.shardIterator();
        }
        LOG.trace("Shard Iterator is: {}", (Object)this.currentShardIterator);
        return this.currentShardIterator;
    }

    private GetShardIteratorRequest buildGetShardIteratorRequest(String streamArn, ShardIteratorType iteratorType, String sequenceNumber) {
        GetShardIteratorRequest.Builder req = GetShardIteratorRequest.builder().streamArn(streamArn).shardId(this.currentShard.shardId()).shardIteratorType(iteratorType);
        switch (iteratorType) {
            case AFTER_SEQUENCE_NUMBER: 
            case AT_SEQUENCE_NUMBER: {
                if (BigIntComparisons.Conditions.LTEQ.matches(new BigInteger(this.currentShard.sequenceNumberRange().startingSequenceNumber()), new BigInteger(sequenceNumber))) {
                    req.sequenceNumber(sequenceNumber);
                    break;
                }
                req.shardIteratorType(ShardIteratorType.TRIM_HORIZON);
                break;
            }
        }
        return (GetShardIteratorRequest)req.build();
    }

    private Shard resolveNewShard(ShardIteratorType type, String resumeFrom) {
        switch (type) {
            case AFTER_SEQUENCE_NUMBER: {
                return this.shardList.afterSeq(resumeFrom != null ? resumeFrom : this.getEndpoint().getSequenceNumber());
            }
            case AT_SEQUENCE_NUMBER: {
                return this.shardList.atSeq(this.getEndpoint().getSequenceNumber());
            }
            case TRIM_HORIZON: {
                return this.shardList.first();
            }
        }
        return this.shardList.last();
    }

    void updateShardIterator(String nextShardIterator) {
        this.currentShardIterator = nextShardIterator;
    }

    Ddb2StreamEndpoint getEndpoint() {
        return this.endpoint;
    }

    private DynamoDbStreamsClient getClient() {
        return this.getEndpoint().getClient();
    }
}

