/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.util.Map;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConsumer;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;

public class Ddb2StreamConsumerHealthCheck
extends AbstractHealthCheck {
    private final Ddb2StreamConsumer ddb2StreamConsumer;
    private final String routeId;

    public Ddb2StreamConsumerHealthCheck(Ddb2StreamConsumer ddb2StreamConsumer, String routeId) {
        super("camel", "aws2-ddbstream-consumer-" + routeId);
        this.ddb2StreamConsumer = ddb2StreamConsumer;
        this.routeId = routeId;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try {
            DynamoDbStreamsClient client;
            Ddb2StreamConfiguration configuration = this.ddb2StreamConsumer.getEndpoint().getConfiguration();
            if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !DynamoDbStreamsClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            if (!configuration.isUseDefaultCredentialsProvider().booleanValue()) {
                AwsBasicCredentials cred = AwsBasicCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey());
                DynamoDbStreamsClientBuilder clientBuilder = DynamoDbStreamsClient.builder();
                client = (DynamoDbStreamsClient)((DynamoDbStreamsClientBuilder)((DynamoDbStreamsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred))).region(Region.of((String)configuration.getRegion()))).build();
            } else if (ObjectHelper.isNotEmpty((Object)configuration.getAmazonDynamoDbStreamsClient())) {
                client = configuration.getAmazonDynamoDbStreamsClient();
            } else {
                DynamoDbStreamsClientBuilder clientBuilder = DynamoDbStreamsClient.builder();
                client = (DynamoDbStreamsClient)((DynamoDbStreamsClientBuilder)clientBuilder.region(Region.of((String)configuration.getRegion()))).build();
            }
            client.listStreams();
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

