/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;

public class DescribeTableCommand
extends AbstractDdbCommand {
    public DescribeTableCommand(DynamoDbClient ddbClient, Ddb2Configuration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        DescribeTableResponse result = this.ddbClient.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.determineTableName()).build());
        Message msg = this.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsDdbTableName", (Object)result.table().tableName());
        msg.setHeader("CamelAwsDdbTableStatus", (Object)result.table().tableStatus());
        msg.setHeader("CamelAwsDdbCreationDate", (Object)result.table().creationDateTime());
        msg.setHeader("CamelAwsDdbTableItemCount", (Object)result.table().itemCount());
        msg.setHeader("CamelAwsDdbKeySchema", (Object)result.table().keySchema());
        msg.setHeader("CamelAwsDdbReadCapacity", (Object)result.table().provisionedThroughput().readCapacityUnits());
        msg.setHeader("CamelAwsDdbWriteCapacity", (Object)result.table().provisionedThroughput().writeCapacityUnits());
        msg.setHeader("CamelAwsDdbTableSize", (Object)result.table().tableSizeBytes());
    }
}

