/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamComponent;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ddbstream", title="AWS 2 DynamoDB Streams", consumerOnly=true, syntax="aws2-ddbstream:tableName", category={Category.CLOUD, Category.MESSAGING, Category.STREAMS})
public class Ddb2StreamEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    Ddb2StreamConfiguration configuration;
    private DynamoDbStreamsClient ddbStreamClient;

    public Ddb2StreamEndpoint(String uri, Ddb2StreamConfiguration configuration, Ddb2StreamComponent component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Ddb2StreamConsumer consumer = new Ddb2StreamConsumer(this, processor);
        consumer.setSchedulerProperties(consumer.getEndpoint().getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ddbStreamClient = this.configuration.getAmazonDynamoDbStreamsClient() != null ? this.configuration.getAmazonDynamoDbStreamsClient() : this.createDdbStreamClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonDynamoDbStreamsClient()) && this.ddbStreamClient != null) {
            this.ddbStreamClient.close();
        }
        super.doStop();
    }

    public Ddb2StreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public DynamoDbStreamsClient getClient() {
        return this.ddbStreamClient;
    }

    public String getSequenceNumber() {
        switch (this.configuration.getIteratorType()) {
            case AFTER_SEQUENCE_NUMBER: 
            case AT_SEQUENCE_NUMBER: {
                if (null == this.configuration.getSequenceNumberProvider()) {
                    throw new IllegalStateException("sequenceNumberProvider must be provided, either as an implementation of SequenceNumberProvider or a literal String.");
                }
                return this.configuration.getSequenceNumberProvider().getSequenceNumber();
            }
        }
        return "";
    }

    DynamoDbStreamsClient createDdbStreamClient() {
        DynamoDbStreamsClient client = null;
        DynamoDbStreamsClientBuilder clientBuilder = DynamoDbStreamsClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (DynamoDbStreamsClientBuilder)((DynamoDbStreamsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (DynamoDbStreamsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (DynamoDbStreamsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (DynamoDbStreamsClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (DynamoDbStreamsClient)clientBuilder.build();
        return client;
    }

    public String toString() {
        return "DdbStreamEndpoint{tableName=" + this.configuration.getTableName() + ", amazonDynamoDbStreamsClient=[redacted], maxResultsPerRequest=" + this.configuration.getMaxResultsPerRequest() + ", iteratorType=" + this.configuration.getIteratorType() + ", sequenceNumberProvider=" + this.configuration.getSequenceNumberProvider() + ", uri=" + this.getEndpointUri() + '}';
    }
}

