/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;

public class DeleteTableCommand
extends AbstractDdbCommand {
    public DeleteTableCommand(DynamoDbClient ddbClient, Ddb2Configuration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        TableDescription tableDescription = this.ddbClient.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName(this.determineTableName()).build()).tableDescription();
        HashMap<Object, Object> tmp = new HashMap<Object, Object>();
        tmp.put("CamelAwsDdbProvisionedThroughput", tableDescription.provisionedThroughput());
        tmp.put("CamelAwsDdbCreationDate", tableDescription.creationDateTime());
        tmp.put("CamelAwsDdbTableItemCount", tableDescription.itemCount());
        tmp.put("CamelAwsDdbKeySchema", tableDescription.keySchema());
        tmp.put("CamelAwsDdbTableName", tableDescription.tableName());
        tmp.put("CamelAwsDdbTableSize", tableDescription.tableSizeBytes());
        tmp.put("CamelAwsDdbTableStatus", tableDescription.tableStatus());
        this.addToResults(tmp);
    }
}

