/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Ddb2StreamEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":tableName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "aws2-ddbstream".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "tableName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(35);
        props.add("accessKey");
        props.add("amazonDynamoDbStreamsClient");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("delay");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("greedy");
        props.add("initialDelay");
        props.add("maxResultsPerRequest");
        props.add("overrideEndpoint");
        props.add("pollStrategy");
        props.add("profileCredentialsName");
        props.add("proxyHost");
        props.add("proxyPort");
        props.add("proxyProtocol");
        props.add("region");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("secretKey");
        props.add("sendEmptyMessageWhenIdle");
        props.add("startScheduler");
        props.add("streamIteratorType");
        props.add("tableName");
        props.add("timeUnit");
        props.add("trustAllCertificates");
        props.add("uriEndpointOverride");
        props.add("useDefaultCredentialsProvider");
        props.add("useFixedDelay");
        props.add("useProfileCredentialsProvider");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("accessKey");
        secretProps.add("secretKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

