/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="aws2-ddbstream:application-cloudevents", description="Adds CloudEvent headers to the Camel message with AWS Dynamo DB Streams get records response details")
public class Ddb2StreamCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.aws.ddbstream.getRecords");
        if (message.getHeaders().containsKey("CamelAwsDdbStreamEventSource")) {
            headers.put("CamelCloudEventSource", "aws.s3.ddbstream." + (String)message.getHeader("CamelAwsDdbStreamEventSource", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAwsDdbStreamEventId", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

