/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.AWS2EC2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="aws2-ec2")
public class AWS2EC2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2EC2Component.class);
    @Metadata
    private AWS2EC2Configuration configuration = new AWS2EC2Configuration();

    public AWS2EC2Component() {
        this(null);
    }

    public AWS2EC2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AWS2EC2Configuration configuration = this.configuration != null ? this.configuration.copy() : new AWS2EC2Configuration();
        AWS2EC2Endpoint endpoint = new AWS2EC2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (!(configuration.isUseDefaultCredentialsProvider().booleanValue() || configuration.getAmazonEc2Client() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, amazonEC2Client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public AWS2EC2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AWS2EC2Configuration configuration) {
        this.configuration = configuration;
    }
}

