/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ec2.AWS2EC2ComponentVerifierExtension;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.AWS2EC2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.ec2.Ec2Client;

@org.apache.camel.spi.annotations.Component(value="aws2-ec2")
public class AWS2EC2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2EC2Component.class);
    @Metadata
    private AWS2EC2Configuration configuration = new AWS2EC2Configuration();

    public AWS2EC2Component() {
        this(null);
    }

    public AWS2EC2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new AWS2EC2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AWS2EC2Configuration configuration = this.configuration != null ? this.configuration.copy() : new AWS2EC2Configuration();
        AWS2EC2Endpoint endpoint = new AWS2EC2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration, endpoint);
        }
        if (configuration.getAmazonEc2Client() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonEC2Client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public AWS2EC2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AWS2EC2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(AWS2EC2Configuration configuration, AWS2EC2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonEc2Client())) {
            LOG.debug("Looking for an Ec2Client instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(Ec2Client.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one Ec2Client instance in the registry");
                configuration.setAmazonEc2Client((Ec2Client)clients.stream().findFirst().get());
            } else {
                LOG.debug("No Ec2Client instance in the registry");
            }
        } else {
            LOG.debug("Ec2Client instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

