/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import java.util.Map;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;

public class AWS2EC2ComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public AWS2EC2ComponentVerifierExtension() {
        this("aws2-ec2");
    }

    public AWS2EC2ComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"accessKey", parameters)).error(ResultErrorHelper.requiresOption((String)"secretKey", parameters)).error(ResultErrorHelper.requiresOption((String)"region", parameters));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            AWS2EC2Configuration configuration = (AWS2EC2Configuration)this.setProperties(new AWS2EC2Configuration(), parameters);
            if (!Ec2Client.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER, (String)"The service is not supported in this region");
                return builder.error(errorBuilder.build()).build();
            }
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey());
            Ec2ClientBuilder clientBuilder = Ec2Client.builder();
            Ec2Client client = (Ec2Client)((Ec2ClientBuilder)((Ec2ClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred))).region(Region.of((String)configuration.getRegion()))).build();
            client.describeInstances();
        }
        catch (AwsServiceException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).detail("aws_ec2_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)((Object)((Object)e)).getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException((Exception)e).build());
        }
        return builder.build();
    }
}

