/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import java.util.Arrays;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.AWS2EC2Endpoint;
import org.apache.camel.component.aws2.ec2.AWS2EC2Operations;
import org.apache.camel.component.aws2.ec2.AWS2EC2ProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesResponse;

public class AWS2EC2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2EC2Producer.class);
    private AWS2EC2ProducerHealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;
    private transient String ec2ProducerToString;

    public AWS2EC2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case createAndRunInstances: {
                this.createAndRunInstance(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case startInstances: {
                this.startInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case stopInstances: {
                this.stopInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case terminateInstances: {
                this.terminateInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case describeInstances: {
                this.describeInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case describeInstancesStatus: {
                this.describeInstancesStatus(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case rebootInstances: {
                this.rebootInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case monitorInstances: {
                this.monitorInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case unmonitorInstances: {
                this.unmonitorInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case createTags: {
                this.createTags(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case deleteTags: {
                this.deleteTags(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private AWS2EC2Operations determineOperation(Exchange exchange) {
        AWS2EC2Operations operation = (AWS2EC2Operations)((Object)exchange.getIn().getHeader("CamelAwsEC2Operation", AWS2EC2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected AWS2EC2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.ec2ProducerToString == null) {
            this.ec2ProducerToString = "EC2Producer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.ec2ProducerToString;
    }

    public AWS2EC2Endpoint getEndpoint() {
        return (AWS2EC2Endpoint)super.getEndpoint();
    }

    private void createAndRunInstance(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RunInstancesRequest) {
                RunInstancesResponse result;
                try {
                    result = ec2Client.runInstances((RunInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Run Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Creating and running instances requests performing");
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            RunInstancesResponse result;
            RunInstancesRequest.Builder builder = RunInstancesRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2ImageId"))) {
                throw new IllegalArgumentException("AMI must be specified");
            }
            String ami = (String)exchange.getIn().getHeader("CamelAwsEC2ImageId", String.class);
            builder.imageId(ami);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceType"))) {
                throw new IllegalArgumentException("Instance Type must be specified");
            }
            InstanceType instanceType = (InstanceType)exchange.getIn().getHeader("CamelAwsEC2InstanceType", InstanceType.class);
            builder.instanceType(instanceType.toString());
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceMinCount"))) {
                throw new IllegalArgumentException("Min instances count must be specified");
            }
            int minCount = (Integer)exchange.getIn().getHeader("CamelAwsEC2InstanceMinCount", Integer.class);
            builder.minCount(Integer.valueOf(minCount));
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceMaxCount"))) {
                throw new IllegalArgumentException("Max instances count must be specified");
            }
            int maxCount = (Integer)exchange.getIn().getHeader("CamelAwsEC2InstanceMaxCount", Integer.class);
            builder.maxCount(Integer.valueOf(maxCount));
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceMonitoring"))) {
                boolean monitoring = (Boolean)exchange.getIn().getHeader("CamelAwsEC2InstanceMonitoring", Boolean.class);
                RunInstancesMonitoringEnabled.Builder monitoringEnabled = RunInstancesMonitoringEnabled.builder();
                monitoringEnabled.enabled(Boolean.valueOf(monitoring));
                builder.monitoring((RunInstancesMonitoringEnabled)monitoringEnabled.build());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceKernelId"))) {
                String kernelId = (String)exchange.getIn().getHeader("CamelAwsEC2InstanceKernelId", String.class);
                builder.kernelId(kernelId);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceEbsOptimized"))) {
                boolean ebsOptimized = (Boolean)exchange.getIn().getHeader("CamelAwsEC2InstanceEbsOptimized", Boolean.class);
                builder.ebsOptimized(Boolean.valueOf(ebsOptimized));
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceSecurityGroups"))) {
                Collection securityGroups = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstanceSecurityGroups", Collection.class);
                builder.securityGroups(securityGroups);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesKeyPair"))) {
                String keyName = (String)exchange.getIn().getHeader("CamelAwsEC2InstancesKeyPair", String.class);
                builder.keyName(keyName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesClientToken"))) {
                String clientToken = (String)exchange.getIn().getHeader("CamelAwsEC2InstancesClientToken", String.class);
                builder.clientToken(clientToken);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesPlacement"))) {
                Placement placement = (Placement)exchange.getIn().getHeader("CamelAwsEC2InstancesPlacement", Placement.class);
                builder.placement(placement);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2SubnetId"))) {
                String subnetId = (String)exchange.getIn().getHeader("CamelAwsEC2SubnetId", String.class);
                builder.subnetId(subnetId);
            }
            try {
                result = ec2Client.runInstances((RunInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Run Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            LOG.trace("Creating and running instances with ami [{}] and instance type {}", (Object)ami, (Object)instanceType);
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void startInstances(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StartInstancesRequest) {
                StartInstancesResponse result;
                try {
                    result = ec2Client.startInstances((StartInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Start Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Starting instances with Ids [{}] ", (Object)((StartInstancesRequest)payload).instanceIds());
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StartInstancesResponse result;
            StartInstancesRequest.Builder builder = StartInstancesRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.instanceIds(instanceIds);
            try {
                result = ec2Client.startInstances((StartInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Starting instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void stopInstances(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StopInstancesRequest) {
                StopInstancesResponse result;
                try {
                    result = ec2Client.stopInstances((StopInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Stop Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Stopping instances with Ids [{}] ", (Object)((StopInstancesRequest)payload).instanceIds());
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StopInstancesResponse result;
            StopInstancesRequest.Builder builder = StopInstancesRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.instanceIds(instanceIds);
            try {
                result = ec2Client.stopInstances((StopInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Stop Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Stopping instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void terminateInstances(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof TerminateInstancesRequest) {
                TerminateInstancesResponse result;
                try {
                    result = ec2Client.terminateInstances((TerminateInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Terminate Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Terminating instances with Ids [{}] ", (Object)((TerminateInstancesRequest)payload).instanceIds());
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            TerminateInstancesResponse result;
            TerminateInstancesRequest.Builder builder = TerminateInstancesRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.instanceIds(instanceIds);
            try {
                result = ec2Client.terminateInstances((TerminateInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Terminate Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Terminating instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeInstances(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeInstancesRequest) {
                DescribeInstancesResponse result;
                try {
                    result = ec2Client.describeInstances((DescribeInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeInstancesResponse result;
            DescribeInstancesRequest.Builder builder = DescribeInstancesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
                builder.instanceIds(instanceIds);
            }
            try {
                result = ec2Client.describeInstances((DescribeInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeInstancesStatus(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeInstanceStatusRequest) {
                DescribeInstanceStatusResponse result;
                try {
                    result = ec2Client.describeInstanceStatus((DescribeInstanceStatusRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Instances Status command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeInstanceStatusResponse result;
            DescribeInstanceStatusRequest.Builder builder = DescribeInstanceStatusRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
                builder.instanceIds(instanceIds);
            }
            try {
                result = ec2Client.describeInstanceStatus((DescribeInstanceStatusRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Instances Status command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void rebootInstances(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RebootInstancesRequest) {
                try {
                    LOG.trace("Rebooting instances with Ids [{}] ", (Object)((RebootInstancesRequest)payload).instanceIds());
                    ec2Client.rebootInstances((RebootInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Reboot Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
            }
        } else {
            RebootInstancesRequest.Builder builder = RebootInstancesRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.instanceIds(instanceIds);
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Rebooting instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
                }
                ec2Client.rebootInstances((RebootInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Reboot Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
        }
    }

    private void monitorInstances(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof MonitorInstancesRequest) {
                MonitorInstancesResponse result;
                try {
                    result = ec2Client.monitorInstances((MonitorInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Monitor Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Start Monitoring instances with Ids [{}] ", (Object)((MonitorInstancesRequest)payload).instanceIds());
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            MonitorInstancesResponse result;
            MonitorInstancesRequest.Builder builder = MonitorInstancesRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.instanceIds(instanceIds);
            try {
                result = ec2Client.monitorInstances((MonitorInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Monitor Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Start Monitoring instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void unmonitorInstances(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UnmonitorInstancesRequest) {
                UnmonitorInstancesResponse result;
                try {
                    result = ec2Client.unmonitorInstances((UnmonitorInstancesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Unmonitor Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Stop Monitoring instances with Ids [{}] ", (Object)((UnmonitorInstancesRequest)payload).instanceIds());
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UnmonitorInstancesResponse result;
            UnmonitorInstancesRequest.Builder builder = UnmonitorInstancesRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.instanceIds(instanceIds);
            try {
                result = ec2Client.unmonitorInstances((UnmonitorInstancesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Unmonitor Instances command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Stop Monitoring instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createTags(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateTagsRequest) {
                CreateTagsResponse result;
                try {
                    result = ec2Client.createTags((CreateTagsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create tags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Created tags [{}] ", (Object)((CreateTagsRequest)payload).tags());
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateTagsResponse result;
            CreateTagsRequest.Builder builder = CreateTagsRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.resources(instanceIds);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesTags"))) {
                throw new IllegalArgumentException("Tags must be specified");
            }
            Collection tags = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesTags", Collection.class);
            builder.tags(tags);
            try {
                result = ec2Client.createTags((CreateTagsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create tags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created tags [{}] on resources with Ids [{}] ", (Object)Arrays.toString(tags.toArray()), (Object)Arrays.toString(instanceIds.toArray()));
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteTags(Ec2Client ec2Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteTagsRequest) {
                DeleteTagsResponse result;
                try {
                    result = ec2Client.deleteTags((DeleteTagsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete tags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                LOG.trace("Delete tags [{}]  ", (Object)((DeleteTagsRequest)payload).tags());
                Message message = AWS2EC2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteTagsResponse result;
            DeleteTagsRequest.Builder builder = DeleteTagsRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
                throw new IllegalArgumentException("Instances Ids must be specified");
            }
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            builder.resources(instanceIds);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesTags"))) {
                throw new IllegalArgumentException("Tags must be specified");
            }
            Collection tags = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesTags", Collection.class);
            builder.tags(tags);
            try {
                result = ec2Client.deleteTags((DeleteTagsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete tags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Delete tags [{}] on resources with Ids [{}] ", (Object)Arrays.toString(tags.toArray()), (Object)Arrays.toString(instanceIds.toArray()));
            }
            Message message = AWS2EC2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new AWS2EC2ProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

