/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ecs;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ecs.ECS2ComponentVerifierExtension;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.ECS2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.ecs.EcsClient;

@org.apache.camel.spi.annotations.Component(value="aws2-ecs")
public class ECS2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ECS2Component.class);
    @Metadata
    private ECS2Configuration configuration = new ECS2Configuration();

    public ECS2Component() {
        this(null);
    }

    public ECS2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new ECS2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ECS2Configuration configuration = this.configuration != null ? this.configuration.copy() : new ECS2Configuration();
        ECS2Endpoint endpoint = new ECS2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (configuration.getEcsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon ecs client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public ECS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ECS2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(ECS2Configuration configuration, ECS2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getEcsClient())) {
            LOG.debug("Looking for an EcsClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(EcsClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one EcsClient instance in the registry");
                configuration.setEcsClient((EcsClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No EcsClient instance in the registry");
            }
        } else {
            LOG.debug("EcsClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

