/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ecs;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.ecs.ECS2Component;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.ECS2Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ecs.EcsClient;

public class ECS2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private ECS2Configuration getOrCreateConfiguration(ECS2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new ECS2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ECS2Component target = (ECS2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)ECS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)ECS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((ECS2Configuration)ECS2ComponentConfigurer.property((CamelContext)camelContext, ECS2Configuration.class, (Object)value));
                return true;
            }
            case "ecsclient": 
            case "ecsClient": {
                this.getOrCreateConfiguration(target).setEcsClient((EcsClient)ECS2ComponentConfigurer.property((CamelContext)camelContext, EcsClient.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)ECS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((ECS2Operations)((Object)ECS2ComponentConfigurer.property((CamelContext)camelContext, ECS2Operations.class, (Object)value)));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                this.getOrCreateConfiguration(target).setPojoRequest((Boolean)ECS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)ECS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)ECS2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)ECS2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)ECS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)ECS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)ECS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"ecsClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return ECS2Configuration.class;
            }
            case "ecsclient": 
            case "ecsClient": {
                return EcsClient.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return ECS2Operations.class;
            }
            case "pojorequest": 
            case "pojoRequest": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ECS2Component target = (ECS2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "ecsclient": 
            case "ecsClient": {
                return this.getOrCreateConfiguration(target).getEcsClient();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return this.getOrCreateConfiguration(target).isPojoRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
        }
        return null;
    }
}

