/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ecs;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ecs.ECS2ClientHealthCheck;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.ECS2Constants;
import org.apache.camel.component.aws2.ecs.ECS2Producer;
import org.apache.camel.component.aws2.ecs.client.ECS2ClientFactory;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.ecs.EcsClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ecs", title="AWS Elastic Container Service (ECS)", syntax="aws2-ecs:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=ECS2Constants.class)
public class ECS2Endpoint
extends ScheduledPollEndpoint {
    private EcsClient ecsClient;
    private ComponentsHealthCheckRepository healthCheckRepository;
    private ECS2ClientHealthCheck clientHealthCheck;
    @UriParam
    private ECS2Configuration configuration;

    public ECS2Endpoint(String uri, Component component, ECS2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new ECS2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ecsClient = this.configuration.getEcsClient() != null ? this.configuration.getEcsClient() : ECS2ClientFactory.getEcsClient(this.configuration).getEcsClient();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.clientHealthCheck = new ECS2ClientHealthCheck(this, this.getId());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.clientHealthCheck);
        }
    }

    public void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.clientHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.clientHealthCheck);
            this.clientHealthCheck = null;
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getEcsClient()) && this.ecsClient != null) {
            this.ecsClient.close();
        }
        super.doStop();
    }

    public ECS2Configuration getConfiguration() {
        return this.configuration;
    }

    public EcsClient getEcsClient() {
        return this.ecsClient;
    }
}

