/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eks;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.eks.EKS2ComponentVerifierExtension;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.eks.EksClient;

@org.apache.camel.spi.annotations.Component(value="aws2-eks")
public class EKS2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(EKS2Component.class);
    @Metadata
    private EKS2Configuration configuration = new EKS2Configuration();

    public EKS2Component() {
        this(null);
    }

    public EKS2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new EKS2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EKS2Configuration configuration = this.configuration != null ? this.configuration.copy() : new EKS2Configuration();
        EKS2Endpoint endpoint = new EKS2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (configuration.getEksClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon eks client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public EKS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EKS2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(EKS2Configuration configuration, EKS2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getEksClient())) {
            LOG.debug("Looking for an EksClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(EksClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one EksClient instance in the registry");
                configuration.setEksClient((EksClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No EksClient instance in the registry");
            }
        } else {
            LOG.debug("EksClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

