/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eventbridge.client;

import org.apache.camel.component.aws2.eventbridge.EventbridgeConfiguration;
import org.apache.camel.component.aws2.eventbridge.client.EventbridgeInternalClient;
import org.apache.camel.component.aws2.eventbridge.client.impl.EventbridgeClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.eventbridge.client.impl.EventbridgeClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.eventbridge.client.impl.EventbridgeClientSessionTokenImpl;
import org.apache.camel.component.aws2.eventbridge.client.impl.EventbridgeClientStandardImpl;

public final class EventbridgeClientFactory {
    private EventbridgeClientFactory() {
    }

    public static EventbridgeInternalClient getEventbridgeClient(EventbridgeConfiguration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new EventbridgeClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new EventbridgeClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new EventbridgeClientSessionTokenImpl(configuration);
        }
        return new EventbridgeClientStandardImpl(configuration);
    }
}

